; draws a circle at x, y with radius r and color c
pro drawcircle, x, y, r, c, dotted
  if dotted then smoothness = 8.0 else smoothness = 36.0
  circle = fltarr(2, smoothness + 1)
  for i = 0.0, smoothness do begin
      j = i / smoothness * 3.14159 * 2
      circle[0, i] = x + r * cos(j)
      circle[1, i] = y + r * sin(j)
  endfor
  plots, circle, /device, color = c, psym = 3 * dotted
end

