function intToStr, i
  return, strmid(strcompress(i), 1, 100)
end

pro aziplot
  print, ''
  print, ''
  print, 'What kind of plot would you like to do?'
  print, '1) MLT'
  print, '2) Magnetic longitude'
  plotType = 0
  read, plotType
  if not (plotType) eq 1 then plotType = 2
  if plotType eq 1 then ext = 'mlt' else ext = 'mlon'
  prefix = 'output/'
  flist = findfile(prefix + '*.' + ext)
  flist = strmid(flist, strlen(prefix), 1000)
  flist = flist[sort(flist)]
  print, ''
  for i = 0, n_elements(flist) - 1 do begin
      print, intToStr(i + 1) + ') ' + flist[i]
  endfor
  print, ''
  splitPoint = 0
  print, 'Where do you want to split the data set? (0 to not split)'
  read, splitPoint

  files2 = 0

  if splitPoint le 1 or splitPoint gt n_elements(flist) then begin
      files1 = flist
      usegroup2 = 0
  endif else begin
      files1 = flist[0:(splitPoint - 2)]
      files2 = flist[(splitPoint - 1):n_elements(flist) - 1]
      usegroup2 = 1
      colorGrp = 0
      read, 'Which group do you want to color? (1 or 2): ', colorGrp
      if colorGrp eq 2 then begin
          z = files1
          files1 = files2
          files2 = z
      endif
  endelse

  if n_elements(files1) gt 1 or n_elements(files2) gt 1 then begin
      colorOrder = 0
      read, 'Enter 1 for darker = older, otherwise 0: ', colorOrder
      if colorOrder eq 0 then begin
          files1 = reverse(files1)
          if usegroup2 then files2 = reverse(files2)
      endif
  endif

  print, ''
  group1scale = 1.00
  group2scale = 1.00
  if usegroup2 then begin
      read, prompt = 'Enter scaling factor for group 1: ', group1scale
      read, prompt = 'Enter scaling factor for group 2: ', group2scale
  endif

  print, ''
  rep = 0.0
  read, prompt = 'How much of the dataset do you want to repeat: ', rep

  outname = 'output.ps'
  hard = 1

  legend = 1

  shift1 = 0
  shift2 = 0

  if usegroup2 then files = [files1, files2] else files = files1

  filenames = prefix + files
  filesFormatted = strmid(files, 0, 4) + "/" + strmid(files, 4, 3) + "/" + $
                   strmid(files, 7, 2) + ":" + strmid(files, 9, 2) + $
                   ", r1 = " + intToStr(fix(strmid(files,12,2))) + "." + $
                   strmid(files,14,2) + ", r2 = "  + $
                   intToStr(fix(strmid(files,17,2))) + "." + $
                   strmid(files,19,2)

  title1 = 'Azimuthal Brightness Comparison'
  yTitle1 = 'Brightness (avg. counts)'
  if plotType eq 1 then xTitle1 = 'MLT' else xTitle1 = 'Magnetic Longitude'

  numfiles1 = n_elements(files1)
  if usegroup2 then numfiles2 = n_elements(files2) else numfiles2 = 0

  numfiles = numfiles1 + numfiles2

  xdatasets = ptrarr(numfiles)
  ydatasets = ptrarr(numfiles)
  
  for i = 0, numfiles - 1 do begin
      filelen = numlines(filenames[i])
      repamt = fix(filelen * rep)
      xdata = fltarr(filelen)
      ydata = fltarr(filelen)
      openr, 1, filenames[i]
      for j = 0, filelen - 1 do begin
          readf, 1, x, y
          xdata[j] = x
          ydata[j] = y
      endfor
      close, 1
      
      if i lt numfiles1 then ydata = ydata * group1scale $
                        else ydata = ydata * group2scale

      if plotType eq 1 then offset = 24.0 else offset = 360.0
      xdata = [xdata, xdata[0:repamt - 1] + offset]
      ydata = [ydata, ydata[0:repamt - 1]]

      xdatasets[i] = ptr_new(xdata)
      ydatasets[i] = ptr_new(ydata)
  endfor
     
  if hard then begin
      loadct, 41
      
      !p.thick=6
      !p.charsize=1.5
      !p.charthick=6
      !x.thick=3
      !y.thick=3
      !y.margin=2
      !p.linestyle = 0
  
      !p.font = 0
      set_plot,'ps'
      device, /helvetica
      device,filename=outname
      device,/landscape
      device,BITS = 8, /color

      white = 127
      black = 0

  endif else begin
      !p.thick=1
      !p.thick=1
      !p.charsize=1
      !p.charthick=1
      !x.thick=1
      !y.thick=1
      !p.font = -1
      !x.margin=[10,4]
      !y.margin=[5,2]
      set_plot, 'x'             ; for linux

      white = 'FFFFFF'XUL
      black = 0
  endelse

  first1 = 128
  last1 = 245

  first2 = 0
  last2 = 64

  step1 = 0
  if numfiles1 gt 1 then step1 = float(last1 - first1) / (numfiles1 - 1)

  c = intarr(numfiles)
  t = intarr(numfiles)

  if usegroup2 then begin
      step2 = 0
      if numfiles2 gt 1 then step2 = float(last2 - first2) / (numfiles2 - 1)
  endif

  t = t + 6
  
  for i = 0, numfiles1 - 1 do begin
      if hard then $
          c[i] = first1 + i * step1 $
      else $
          c[i] = (first1 + i * step1) * '020202'XUL
  endfor

  for i = 0, numfiles2 - 1 do begin
      if hard then $
          c[i + numfiles1] = first2 + i * step2 $
      else $
          c[i + numfiles1] = (first2 + i * step2 - 128) * '020200'XUL
  endfor

  !p.background = white
  !p.color = 0

  xmin = 1000
  xmax = -1000
  ymin = 1000
  ymax = -1000

  for i = 0, numfiles - 1 do begin
      thisX = (*xdatasets[i])
      thisMin = min(thisX)
      thisMax = max(thisX)
      if thisMin LT xmin then xmin = thisMin
      if thisMax GT xmax then xmax = thisMax

      thisY = (*ydatasets[i])
      thisMin = min(thisY)
      thisMax = max(thisY)
      if thisMin LT ymin then ymin = thisMin
      if thisMax GT ymax then ymax = thisMax

      xdatasets[i] = ptr_new(thisX)
      ydatasets[i] = ptr_new(thisY)
  endfor    

  !P.multi = 0

  if legend then bmargin = 4 + 1.1 * numfiles else bmargin = 3

  if plotType eq 1 then begin
      xti = 6
      !x.minor = 6
  endif else begin
      xti = 60
      !x.minor = 6
  endelse
  
  plot, [0,1], [0,1], xrange = [xmin, xmax], yrange = [ymin, ymax], $
        title = title1, xTitle = xTitle1, yTitle = yTitle1, $
        ymargin = [bmargin, 3], xtickinterval = xti, /nodata

  !x.minor = 0

  for j = 0, numfiles - 1 do begin
      i = numfiles - 1 - j

      thisX = (*xdatasets[i])
      thisY = (*ydatasets[i])

      oplot, thisX, thisY, color = c[i], thick = t[i]
  endfor

  if legend then begin
      for i = 0, numfiles - 1 do begin
          thisY = (*ydatasets[i])
          print, filesFormatted[i], ' : mean = ', mean(thisY)
          
          ytop = 0.03 * numfiles - (0.03 * i) + 0.003
          ybot = ytop + 0.025 - 0.005
          
          polyfill, [0.1, 0.1, 0.12, 0.12], $
                    [ytop, ybot, ybot, ytop], /norm, color = c[i]
          
          xyouts, 0.13, 0.03 * numfiles - 0.03 * i, $
                  string(filesFormatted[i], ' : mean = ', mean(thisY)), /normal
      endfor
  endif

  if hard then device, /close

  ptr_free, xdatasets
  ptr_free, ydatasets
end
