      SUBROUTINE SUBSETR (KODE)
C
C-----------------------------------------------------------------------
C
C     Prompts for the increment and duration of the subperiods when
C     DEFFRAR is not used.
C
C     Return KODE = -1, end of file in input
C                 =  0, successful input
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original SUBSET written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      INTEGER*2 LUNDAT,LUNIN,LUNOUT
C
      REAL*8    DUR,INC,RUN_TIMES(4),STRIP_TIMES(4)
C
      COMMON    /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /DELUNS/LUNDAT,LUNIN,LUNOUT
C
C-----------------------------------------------------------------------
C     *** prompt for increment and duration ***
C-----------------------------------------------------------------------
C
      KODE=0
      WRITE (LUNOUT,50)
   50 FORMAT (' GIVE DURATION, INCREMENT (SEC) : ',$)
      READ (LUNIN,*,END=99) INC,DUR
      INC=INC*1000000.0D0
      DUR=DUR*1000000.0D0
C
C-----------------------------------------------------------------------
C     *** define initial subperiod ***
C-----------------------------------------------------------------------
C
      IF (INC .LT. 0.0D0) INC=DUR
      IF (DUR .LT. 0.0D0) DUR=INC
      IF (DUR .GT. 0.0D0) CALL ADDTM2R (STRIP_TIMES(1),STRIP_TIMES(2),
     *                            0.0D0,STRIP_TIMES(3),STRIP_TIMES(4))
      IF (INC .GT. 0.0D0  .AND.  DUR .GT.0.0D0)
     *                  CALL ADDTM2R (STRIP_TIMES(1),STRIP_TIMES(2),DUR,
     *                                STRIP_TIMES(3),STRIP_TIMES(4))
      RETURN
C
C-----------------------------------------------------------------------
C     *** End Of Job ***
C-----------------------------------------------------------------------
C
   99 KODE=-1
      RETURN
      END
