	SUBROUTINE SRTANG(MODBLK,CTS,ICTN,NANG,I1,I2,JFLAG)
C
C THIS SUBROUTINE SORTS DATA FOR A GIVEN HEAD AND GIVEN MASS IN
C TERMS OF INSTRUMENT SPIN PHASE ANGLE.
C
C INPUT ARGUMENTS ARE:
C	MODBLK	SEE SENTGS INPUT SUBROUTINE
C	NANG  - NUMBER OF ANGLE BINS FOR ONE SPIN
C	I1    - START SAMPLE INDEX OF DATA TO BE INCLUDED
C	I2    - STOP SAMPLE INDEX. I1, I2 ARE IN RANGE [1,512]
C OUTPUT ARGUMENTS, IN ADDITION TO CTS, CTN,
C	JFLAG - SET TO 0 IF NO DATA ADDED TO ARRAYS, OTHERWISE 1
C
C THE ARRAYS CTS(NANG) AND ICTN(NANG) ARE UPDATED APPROPRIATELY
C NOTE *** BEFORE THIS ROUTINE IS CALLED, THE INFORMATION IN THE
C FOLLOWING COMMON BLOCKS MUST BE DEFINED
C	COMMON	UPDATED BY CALLING
C	------	------------------
C	RPAMSH	GETMOD.  CONTAINS INSTRUMENT RPA, IMS SETTINGS
C	I7FLGS	DEFFGS.  CONTAINS INSTRUMENT MODE FLAGS.
C
C V1.0 JFE JOHNSON 25 JUL 82
C V1.1 JFEJ        17 AUG 82 ADDED IDCODC CALL
C V1.2 JLG	   14 SEPT 82 ADDED ELECTROMETER
C V2.0 R.L.WEST  BSCC  27-JAN-1986
C                if subroutines call were small enough their calls were
C                eleminated and the code actually brought in, also some
C                logic was rearranged.
C V2.1 R.L.WEST   8 JUL 86 INCORPORATE NEW VERSION OF IDCODC
C
	INTEGER*4 IDCODC
	INTEGER JRPA(512),JMSH(512),MODBLK(8)
	INTEGER IDAT(2812),ICDE(512,2),JCR(512,2)
	INTEGER ICTN(NANG),KCEL(512)
	REAL CTS(NANG)
	EQUIVALENCE (ICDE(1,1),IDAT(1789))
	EQUIVALENCE (JCR(1,1),IDAT(253))
	EQUIVALENCE (KCEL(1),IDAT(1277))
	COMMON/RPAMSH/JRPA,JMSH
	COMMON/MAF1/IDAT
C
	JFLAG=0
C
C-----------------------------------------------------------------------
C     *** first call REFANG, to define phase angle reference ***
C-----------------------------------------------------------------------
C
	CALL REFANG(DEGSAM,RAMANG)
C
C-----------------------------------------------------------------------
C     *** see which head ***
C-----------------------------------------------------------------------
C
	IF(MODBLK(1).EQ.4)GO TO 4000		! ELECTROMETER
	IF(MODBLK(1).EQ.1)GO TO 401		! RADIAL
C
C-----------------------------------------------------------------------
C     *** Z head processing ***
C-----------------------------------------------------------------------
C
	IDET=(MODBLK(1)-2)*2+MODBLK(2)		! GET DETECTOR
C
	DO 430 I=I1,I2
	   IF (JRPA(I).LT.MODBLK(5).OR.JRPA(I).GT.MODBLK(6)) THEN
           ELSE
	      IF (JMSH(I).LT. MODBLK(3).OR.JMSH(I).GT.MODBLK(4)) THEN
              ELSE
		 IZMS=IGTZMS(IDET,I)		! HAVE DATA ?
                 IF (IZMS.GT.0) THEN
                    JFLAG=1
                    IANG=IANGLN(DEGSAM,RAMANG,NANG,I)
                    CTS(IANG)=CTS(IANG)+FLOAT(IDCODC(ICDE(I,IZMS),IC))
                    ICTN(IANG)=ICTN(IANG)+IC
                 END IF
	      END IF
	   END IF
  430	CONTINUE
C
	GO TO 9000
C
  401	CONTINUE
C
C-----------------------------------------------------------------------
C     *** RADIAL head processing ***
C-----------------------------------------------------------------------
C
	DO 100 I=I1,I2
	   IF (JRPA(I).LT.MODBLK(5).OR.JRPA(I).GT.MODBLK(6)) THEN
           ELSE
	      IF (JMSH(I).LT. MODBLK(3).OR.JMSH(I).GT.MODBLK(4)) THEN
              ELSE
                 JFLAG=1
                 IANG=IANGLN(DEGSAM,RAMANG,NANG,I)
                 CTS(IANG)=CTS(IANG)+FLOAT(IDCODC(JCR(I,MODBLK(2)),IC))
                 ICTN(IANG)=ICTN(IANG)+IC
	      END IF
	   END IF
  100	CONTINUE
C
 	GO TO 9000
C
 4000	CONTINUE
C
C-----------------------------------------------------------------------
C    *** ELECTROMETER channel ***
C-----------------------------------------------------------------------
C
	DO 5000 I=I1,I2
	   IF (JRPA(I).LT.MODBLK(5).OR.JRPA(I).GT.MODBLK(6)) THEN
           ELSE
              JFLAG=1
              IANG=IANGLN(DEGSAM,RAMANG,NANG,I)
              CTS(IANG)=CTS(IANG)+FLOAT(IDCODC(KCEL(I),IC))
              ICTN(IANG)=ICTN(IANG)+IC
	   END IF
 5000	CONTINUE
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
 9000	CONTINUE
	RETURN
	END
