      SUBROUTINE SCLIMS(IIMS)
C
C-----------------------------------------------------------------------
C
C THIS ROUTINE TAKES THE IMS SETTINGS THAT ARE IN IIMS AND REPLACES
C IT WITH AN INDEX FROM 1 TO 32.
C WRITTEN BY R.C.OLSEN 2/4/82
C
C-----------------------------------------------------------------------
C
      INTEGER*2 EVKEN(32),IIMS(32),IMSH(32),LKUIMS(2,32)
C
      COMMON    /SCALE/LKUIMS,
     *          /KENENG/EVKEN
C
C-----------------------------------------------------------------------
C the values contained in LKUIMS (lookup-IMS) array are IMS settings
C      these values are loaded into LKUIMS by a call to SCLIM2
C-----------------------------------------------------------------------
C
      DO J=1,32
         IIMS(J)=J
      END DO
      RETURN
C
C-----------------------------------------------------------------------
C
      ENTRY SCLIM2(IMSH,IBAD)
C
C-----------------------------------------------------------------------
C
      IBAD = 0
      DO K=1,32
C
         VIMS=IMSH(K)*0.54932
C
C-----------------------------------------------------------------------
C        ***     if VIMS is not 1-50, there is trouble      ***
C        *** check for this, and on ERROR, EXIT with IBAD=1 ***
C-----------------------------------------------------------------------
C
         IF (VIMS .LT. 50.0  .OR.  VIMS .GT. 3000.) THEN
            IBAD=1
            RETURN
         END IF
C
         EVKEN(K)=VIMS+0.5
         LKUIMS(1,K)=(2025.0/VIMS)+0.5     ! low mass
         LKUIMS(2,K)=(8100.0/VIMS)+0.5     ! high mass
C
      END DO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN 
      END
