#module RMSIO V3

/*
**++
**  FACILITY:
**
**      Functions for RMS I/O
**
**  ABSTRACT:
**
**      from VAX/VMS Record Management Services
**
**  AUTHORS:
**
**      R.E.Newman Jr.
**
**
**  CREATION DATE:     9-FEB-1988
**
**  MODIFICATION HISTORY:
**--
**/


/*
**
**  INCLUDE FILES
**
**/

#include "RMSACC.H"
#include STDIO
unsigned long sys$open(), sys$create(), sys$connect(), sys$read(),
 sys$write(), sys$get(), sys$put(), sys$disconnect(), sys$close(),
 sys$display(),sys$parse(),sys$search();
/* Interface Buffer */
struct INTBUF
{
    unsigned char	*ibs, *ibp;
    long ibsz;
    long ibr;
    unsigned char	*obs, *obp;
    long obsz;
    long obr;
};

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Open with RMS
**
**  FORMAL PARAMETERS:
**
**      FAB *ropen(filename,def_name,file_mode,chr_blk,nam)
**
**
**  IMPLICIT INPUTS:
**
**      char *filename;
**	char *def_name;
**	short file_mode;
**	struct chrblk *chr_blk;
**	struct NAM *nam;
**	AVAILABLE file_mode options:
**	F_BLOCK, F_READ, F_WRITE, F_CREAT, F_EXIST, F_TRUNC
**
**  IMPLICIT OUTPUTS:
**
**      fbp=ropen(...);
**
**	struct FAB *fbp;
**
**  SIDE EFFECTS:
**
**      no RMS Status is returned when a file open error occurs.
**
**--
**/
struct FAB *ropen(file_name,def_name,file_mode,chr_blk,nam)
char	*file_name,*def_name;	/* FILE_NAME & DEFAULT FILE_NAME */
unsigned short file_mode;	/* FILE_MODE */
struct chrblk *chr_blk;		/* CHARACTERISTICS_BLOCK */
struct NAM *nam;		/* NAME BLOCK */
{
    struct FAB *fbp;
    struct XABDAT *xdat = 0;
    struct XABFHC *xfhc = 0;
    unsigned long	rmsstat;

    fbp=0;
    fbp =(struct FAB *)malloc(sizeof(struct FAB));
    if(fbp!=0)
	{
	    *fbp = cc$rms_fab;
	    fbp->fab$l_fna=file_name;	/* Set Address of File_Name */
	    fbp->fab$b_fns=(char)strlen(file_name);
	    fbp->fab$l_dna=def_name;	/* Set Address of Def_Name String */
	    if(def_name)fbp->fab$b_dns=(char)strlen(def_name);
	    fbp->fab$b_fac=0;		/* clear type file access */
	    fbp->fab$l_nam=nam;		/* Set Address of NAM BLOCK */
	    if ((file_mode&(F_BLOCK|F_BLKRC))!=0)
		{
		    if((file_mode&F_BLKRC)!=0)	/* Choose Block & Record I/O */
			fbp->fab$b_fac|=FAB$M_BRO;
		    else			/* Choose Block I/O */
			fbp->fab$b_fac|=FAB$M_BIO;
		};
	    if ((file_mode&F_TRUNC)!=0)
		fbp->fab$b_fac|=FAB$M_TRN;
	    if ((file_mode&F_UPDAT)!=0)
		fbp->fab$b_fac|=FAB$M_UPD;
	    if ((file_mode&F_READ)!=0)
		fbp->fab$b_fac|=FAB$M_GET;
	    if ((file_mode&F_WRITE)!=0)
		fbp->fab$b_fac|=FAB$M_PUT;
	    if ((file_mode&F_CREIF)!=0)
		fbp->fab$l_fop|=FAB$M_CIF;
	    if ((file_mode&(F_CREIF|F_CREAT))!=0)
		{
/* Use Characteristics Block to Create */
		    if(chr_blk!=0)
			{
			    xdat=(struct XABDAT *)malloc(sizeof(struct XABDAT));
			    xfhc=(struct XABFHC *)malloc(sizeof(struct XABFHC));
/*** Set File Characteristics ***/
			    if((xdat!=0) && (xfhc!=0))
				{
/* Initialize XABDAT */
				    *xdat = cc$rms_xabdat;
				    *xfhc = cc$rms_xabfhc;
				    xdat->xab$q_cdt=chr_blk->chr$q_cdt;
				    xfhc->xab$w_lrl=chr_blk->chr$w_lrl;
				    fbp->fab$l_alq=chr_blk->chr$l_alq;
				    fbp->fab$w_deq=chr_blk->chr$w_deq;
				    fbp->fab$w_mrs=chr_blk->chr$w_mrs;
				    fbp->fab$b_org=chr_blk->chr$b_org;
				    fbp->fab$b_rat=chr_blk->chr$b_rat;
				    fbp->fab$b_rfm=chr_blk->chr$b_rfm;
				    fbp->fab$b_bks=chr_blk->chr$b_bks;
				    fbp->fab$b_fsz=chr_blk->chr$b_fsz;
				    fbp->fab$l_fop|=chr_blk->chr$l_fop;
				    xdat->xab$l_nxt=xfhc;
				    xfhc->xab$l_nxt=0;
				    fbp->fab$l_xab=xdat;
				};
			};
		    rmsstat=sys$create (fbp, 0 , 0 );
		    if(xdat!=0)
			{   /* Clear XABDAT & XABFHC Block */
			    free(xfhc);
			    free(xdat);
			    fbp->fab$l_xab=0;
			};
		}
	    else
		rmsstat=sys$open (fbp, 0 , 0 );
/* Check OPEN status */
	    if ((rmsstat & 1)==0)
/* Bad Status Return */
		{
		    free(fbp);
		    fbp=0;
		}
	    else
/* Good Status Return */
		{

		    if (((file_mode&(F_CREAT|F_CREIF))==0) && (chr_blk!=0))
			{
			    xdat=(struct XABDAT *)malloc(sizeof(struct XABDAT));
			    xfhc=(struct XABFHC *)malloc(sizeof(struct XABFHC));
/* Check If both extended structures allocated */
			    if((xdat!=0) && (xfhc!=0))
				{
				    *xdat = cc$rms_xabdat;
				    *xfhc = cc$rms_xabfhc;
				    fbp->fab$l_xab=xfhc;
				    xfhc->xab$l_nxt=xdat;
/* Get File Open Bits of FAB$V_CBT/FAB$V_CTG/FAB$V_RCK/FAB$V_WCK */
				    chr_blk->chr$l_fop=fbp->fab$l_fop;

/* Return File Attributes on an open */
				    rmsstat=sys$display (fbp, 0 , 0 );
				    chr_blk->chr$q_cdt=xdat->xab$q_cdt;
				    chr_blk->chr$q_rdt=xdat->xab$q_rdt;
				    chr_blk->chr$l_alq=fbp->fab$l_alq;
				    chr_blk->chr$w_deq=fbp->fab$w_deq;
				    chr_blk->chr$w_mrs=fbp->fab$w_mrs;
				    chr_blk->chr$b_org=fbp->fab$b_org;
				    chr_blk->chr$b_rat=fbp->fab$b_rat;
				    chr_blk->chr$b_rfm=fbp->fab$b_rfm;
				    chr_blk->chr$b_bks=fbp->fab$b_bks;
				    chr_blk->chr$b_fsz=fbp->fab$b_fsz;
/* Save Longest Record Length.*/
				    chr_blk->chr$w_lrl=xfhc->xab$w_lrl;
			    };
			    if(xfhc!=0)free(xfhc);
			    if(xdat!=0)free(xdat);
			    fbp->fab$l_xab=0;
			};
		};
	    };
	return fbp;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Allocate & Initialize a NAM Block
**
**  FORMAL PARAMETERS:
**
**      struct NAM *init_nam(nop,rlfnam)
**
**  IMPLICIT INPUTS:
**
**      unsigned char nop;
**	struct NAM *rlfnam;
**
**  IMPLICIT OUTPUTS:
**
**
**  FUNCTION VALUE:
**
**      RETURN INITIALIZED NAME BLOCK.
**	NULL IF UNSUCCESSFUL.
**
**  SIDE EFFECTS:
**
**
**--
**/
struct NAM  *init_nam(nop, rlfnam)
register unsigned char	nop;
register struct NAM	*rlfnam;
{
    struct NAM	*nmp = 0;

    nmp=(struct NAM *)malloc(sizeof(struct NAM));   /* Allocate NAM Block */
    if (nmp)
	{
	    *nmp = cc$rms_nam;	/* Initialize NAM Block values */
	    nmp->nam$l_rsa=(char *)malloc(NAM$C_MAXRSS);
	    nmp->nam$l_esa=(char *)malloc(NAM$C_MAXRSS);
	    if((nmp->nam$l_rsa != 0) && (nmp->nam$l_esa != 0))
		{
		    nmp->nam$b_rss=NAM$C_MAXRSS;
		    nmp->nam$b_ess=NAM$C_MAXRSS;
		    return nmp;
		}
	    else
		{
		    if(nmp->nam$l_rsa != 0)cfree(nmp->nam$l_rsa);
		    if(nmp->nam$l_esa != 0)cfree(nmp->nam$l_esa);
		    cfree(nmp);
		};
	};
    return (struct NAM *)0;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Initialize FAB & NAM RMS Blocks.
**
**  FORMAL PARAMETERS:
**
**     struct NAM *init_nam_fab(fab,FNS,DNS,NOP)
**
**  IMPLICIT INPUTS:
**
**      unsigned char NOP;
**	char *FNS,*DNS;
**	struct fab *fab;
**
**  IMPLICIT OUTPUTS:
**
**  FUNCTION VALUE:
**
**      address of nam block or zero.
**
**  SIDE EFFECTS:
**
**      [@description_or_none@]
**
**--
**/
struct NAM	*init_nam_fab(fab, FNS, DNS, NOP)
struct FAB	*fab;
register char	*FNS, *DNS;
register unsigned char	NOP;
{
    struct NAM *rnam = 0;

    if (fab)
	{
	    *fab = cc$rms_fab;
	    if(FNS) /* Define File Name String */
		{

		    fab->fab$l_fna=FNS;
		    fab->fab$b_fns=strlen(FNS);
		};
	    if(DNS) /* Define Default Name String */
		{

		    fab->fab$l_dna=DNS;
		    fab->fab$b_dns=strlen(DNS);
		};
	    rnam=init_nam(NOP,0);
	};
    return rnam;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS PARSE & SEARCH FUNCTION
**
**  FORMAL PARAMETERS:
**
**      unsigned long rms_srch(fab,NOP,FNS,DNS)
**
**  IMPLICIT INPUTS:
**
**      unsigned char NOP;
**	char *FNS,*DNS;
**	struct FAB *fab;
**	    set fab->fab$l_ctx = -1 if deallocation of FAB & NAM Blocks wanted.
**	    NOTE: fab pointer must have been initialized by calling rms_srch.
**	    fab->fab$l_ctx == 0 when in (SYS$PARSE STATE)
**	    fab->fab$l_ctx == 1 when in (SYS$SEARCH STATE)
**
**
**  IMPLICIT OUTPUTS:
**
**  FUNCTION VALUE:
**
**	Results to allocate FAB & NAM Blocks:
**
**      =0 - if unable to allocate FAB or NAM Blocks.
**	=ODD VALUE Returned from SYS$PARSE and/or SYS$SEARCH
**	=EVEN VALUE Indicates Error or RMS$_NMF
**
**  SIDE EFFECTS:
**
**      [@description_or_none@]
**
**--
**/
unsigned long	rms_srch(efb, NOP, FNS, DNS)
register unsigned long *efb;
register unsigned char	NOP;
register char	*FNS, *DNS;
{
    unsigned long	rmsstat = 1;
    struct FAB *fab;

    fab=(*efb);
    if (fab==0)	/* File Access Block Not Present - Allocate It. */
	{
	    fab=(struct FAB *)malloc(sizeof(struct FAB));
	    if (fab)
		{
		    fab->fab$l_nam=init_nam_fab(fab,FNS,DNS,NOP);
		    if(fab->fab$l_nam == 0)
			{
/* Free FAB & Return 0 if unable to allocate NAM BLOCK */
			    cfree(fab);
			    *efb=0;
			    return 0;
			};
		    fab->fab$l_ctx=0;	/* Set initial State */
		}
	    else
		return 0;   /* Return 0 if unable to allocate FAB */

	};

    if(fab->fab$l_ctx == 0)
/* ++++ Do Parse of filespec. ++++ */
	{
	    rmsstat=sys$parse (fab, 0 , 0 );
	    if((rmsstat&1) && ((fab->fab$l_nam->nam$b_nop & NAM$M_SYNCHK)==0))
		fab->fab$l_ctx=1;   /* SET SYS$SEARCH STATE */
	};

    if(fab->fab$l_ctx == 1)
/* ++++ Do Search of file(s). ++++ */
	rmsstat=sys$search (fab, 0 , 0 );
    else
/* ++++ Free all allocated Blocks ++++ */
	{
	    if(fab->fab$l_nam)
		{
		    if(fab->fab$l_nam->nam$l_rsa) /* free RSA space */
			cfree(fab->fab$l_nam->nam$l_rsa);
		    if(fab->fab$l_nam->nam$l_esa) /* free ESA space */
			cfree(fab->fab$l_nam->nam$l_esa);
		    cfree(fab->fab$l_nam);	/* FREE NAM BLOCK */
		};
	    cfree(fab);	/* FREE FAB BLOCK */
	    *efb=0;	/* Clear Pointer */
	};
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS CONNECT I/O
**
**  FORMAL PARAMETERS:
**
**      struct RAB *rconn(fbp,blksiz)
**
**  IMPLICIT INPUTS:
**
**      struct FAB *fbp;
**	unsigned long blksiz;
**
**  IMPLICIT OUTPUTS:
**
**	none
**
**  FUNCTION VALUE:
**
**      rbp = rconn(fbp)
**
**	struct RAB *rbp;
**
**  SIDE EFFECTS:
**
**
**--
**/
struct RAB	*rconn(fbp,blksiz)
struct FAB *fbp;
unsigned short blksiz;
{
    struct RAB *rbp;
    unsigned long rmsstat = 0;
    struct INTBUF *ibb;

    rbp = (struct RAB *)malloc(sizeof(struct RAB));
    ibb=(struct INTBUF *)malloc(sizeof (struct INTBUF));
    if(ibb)
	{
	    ibb->ibsz=ibb->obsz=blksiz*512; /* Calculate Buffer Size */

/* Allocate Input Buffer */
	    ibb->ibs= ((blksiz > 0) && (fbp->fab$b_fac&FAB$M_GET)!=0) ?
	     (char *)malloc(ibb->ibsz) : 0;

/* Allocate Output Buffer */
	    ibb->obs= ((blksiz > 0) && (fbp->fab$b_fac&FAB$M_PUT)!=0) ?
	     (char *)malloc(ibb->obsz) : 0;
	};
    if((rbp!=0) && (ibb!=0))
	{
	    *rbp = cc$rms_rab;
/* Set Block I/O Only if FAB$M_BIO set. */
	    if((fbp->fab$b_fac & FAB$M_BIO)!=0)rbp->rab$l_rop|=RAB$M_BIO;
	    rbp->rab$l_fab=fbp;
	    rmsstat=sys$connect (rbp, 0 , 0 );
	    if((rmsstat&1)!=0)
		{
		    if(ibb->ibs != 0)
			{
			    ibb->ibr=0;
			    ibb->ibp=ibb->ibs;/* Set input pointers */
			}
		    else
			{
			    ibb->ibr=0;
			    ibb->ibp=0;
			};
		    if(ibb->obs != 0)
			{
			    ibb->obr=ibb->obsz;
			    ibb->obp=ibb->obs;/* Set output pointers */
			}
		    else
			{
			    ibb->obr=0;
			    ibb->obp=0;
			};
		    rbp->rab$l_bkt=0;   /* Set to default initial block */
		    rbp->rab$l_ctx=ibb;
		};
	};
    if((rmsstat&1)==0)
	{
	    if(ibb->ibs)free(ibb->ibs);
	    if(ibb->obs)free(ibb->obs);
	    free(ibb);
	    free(rbp);
	    rbp=0;
	};
    return rbp;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS I/O Disconnect.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rdisc(rbp)
**
**  IMPLICIT INPUTS:
**
**      none
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O Completion Status.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rdisc(rbp)
struct RAB *rbp;
{
    unsigned long rmsstat;
    struct INTBUF *ibb;

    rmsstat=sys$disconnect (rbp, 0, 0 );
    if(rmsstat & 1)
	{
	    ibb=rbp->rab$l_ctx;
	    if(ibb)
		{
		    free(ibb->ibs);
		    free(ibb->obs);
		    free(ibb);
		};
	    free(rbp);
	};
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS I/O Close
**
**  FORMAL PARAMETERS:
**
**      unsigned long rclose(fbp,chr_blk);
**	struct FAB *fbp;
**	struct chrblk *chr_blk;
**
**  IMPLICIT INPUTS:
**
**      struct FAB *fbp;    -File Was Previously Opened with ropen.
**	struct chrblk *chr_blk;	-Optional Characteristics block.
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      rclose status = RMS I/O Completion Status.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rclose(fbp, chr_blk)
struct FAB *fbp;
struct chrblk *chr_blk;
{
    unsigned long	rmsstat;
    struct XABRDT *xrdt = 0;
    if(chr_blk!=0)
	{
	    xrdt=(struct XABRDT *)malloc(sizeof(struct XABRDT));
	    if(xrdt!=0)
		{
		    *xrdt = cc$rms_xabrdt;

		    xrdt->xab$q_rdt=chr_blk->chr$q_rdt;
		    xrdt->xab$l_nxt=fbp->fab$l_xab;
		    fbp->fab$l_xab=xrdt;
		};
	};

    rmsstat=sys$close (fbp, 0 , 0 );
    if(rmsstat & 1)free(fbp);
    if(xrdt!=0)	/* Free XABRDT BLOCK */
	{
	    free(xrdt);
	    xrdt=0;
	}
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS I/O WRITE Service call.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rwrite(rbp,rec,size,block)
**  struct RAB *rbp;
**  char rec[];
**  unsigned short size;
**  unsigned long block;
**
**  IMPLICIT INPUTS:
**
**      rbp - Record Access Block.
**	rec - record buffer.
**	size - size of record.
**	block - Virtual Block Address.
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O SYS$WRITE COMPLETION STATUS.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rwrite(rbp, rec, size, block)
struct RAB *rbp;
char *rec;
register unsigned short	size;
register unsigned long block;
{
    unsigned long rmsstat;
    rbp->rab$l_rbf=rec;
    rbp->rab$w_rsz=size;
    rbp->rab$l_bkt=block;
    rmsstat=sys$write (rbp, 0 , 0);
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS I/O READ Service call.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rread(rbp,rec,size,block)
**  struct RAB *rbp;
**  char rec[];
**  unsigned short size;
**  unsigned long block;
**
**  IMPLICIT INPUTS:
**
**      rbp - Record Access Block.
**	rec - record buffer.
**	size - size of record.
**	block - Virtual Block Address.
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O SYS$WRITE COMPLETION STATUS.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rread(rbp, rec, size, block)
struct RAB *rbp;
char *rec;
register unsigned short	size;
register unsigned long block;
{
    unsigned long rmsstat;
    rbp->rab$l_ubf=rec;
    rbp->rab$w_usz=size;
    rbp->rab$l_bkt=block;
    rmsstat=sys$read (rbp, 0 , 0);
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Buffered Read Routine for rread.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rbread(rbp,rec,siz,vbn,vbo)
**
**	struct RAB *rbp; - Record Access Block.
**	char *rec; - Record to Read.
**	unsigned short siz; - Size of Record to Read.
**	unsigned long vbn; - Virtual Block Number.
**	unsigned short vbo; - Virtual Block Offset.
**
**  IMPLICIT INPUTS:
**
**      none
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O Completion Status.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rbread(rbp, rec, siz, vbn, vbo)
struct RAB *rbp;
char *rec;
unsigned short siz;
unsigned long vbn;
unsigned short vbo;
{
    register unsigned char	*ubf = 0,*sbf,*dbf;
    unsigned long rmsstat;
    unsigned short csiz,csz;

    csiz=vbo+siz;   /* add offset + size */
    ubf=malloc(csiz);
    rmsstat=rread(rbp,ubf,csiz,vbn);
    if((rmsstat & 1) && (ubf != 0))  /* good status */
	{
	    if(rbp->rab$w_rsz < siz)siz=rbp->rab$w_rsz;
	    for (dbf=rbp,sbf=ubf+vbo,csz=siz;  csz>0;  csz--,dbf++,sbf++)
		(*dbf)=(*sbf);
	};
    free(ubf);
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Buffered Sequential Read Routine for rread.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rsread(rbp,rec,siz,rsiz)
**
**	struct RAB *rbp; - Record Access Block.
**	char *rec; - Record to Read.
**	unsigned short siz; - Size of Record to Read.
**	short *rsiz; - Returned Size Read.
**
**  IMPLICIT INPUTS:
**
**      none
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O Completion Status.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rsread(rbp, rec, siz,rsiz)
struct RAB *rbp;
char *rec;
unsigned short siz;
short *rsiz;
{
    register unsigned char	*sbf,*dbf;
    unsigned long rmsstat = 1;
    short csiz,rksiz=0,minsiz;
    struct INTBUF *ibb;

    dbf=rec;	    /* Set Destination Address */
    csiz=siz;		    /* Set Initial Size to XFER. */
    if((rbp!=0) && ((ibb=rbp->rab$l_ctx)!=0)) /* DO I/O if rbp & ibb != 0 */
	{
/* INTBUF(ibb) POINTER SET */
	    while ((rmsstat & 1) && csiz>0)
		{
		    if(ibb->ibr <= 0)
			{
			    if(rbp->rab$l_sts==RMS$_EOF)
				rmsstat=RMS$_EOF;   /* Set EOF INDICATION */
			    else
				{
				    rmsstat=rread(rbp,ibb->ibs,ibb->ibsz,0);
				    /* Reset Character Pointer */
				    ibb->ibp=ibb->ibs;
				    /* Compute New End Pointer */
				    ibb->ibr=rbp->rab$w_rsz;
				};
			}
		    else
			{

			    minsiz=(csiz <= (ibb->ibr)) ?
				csiz : (ibb->ibr); /* Get Min Size to XFER */
			    csiz -=minsiz;
			    (ibb->ibr)-=minsiz;
			    rksiz +=minsiz;

			    for (sbf=ibb->ibp;minsiz > 0;minsiz--)
				(*dbf++)=(*sbf++);
			    ibb->ibp=sbf;	/* Set Input Pointer */
			};
		};
	    if((rmsstat==RMS$_EOF) && (rksiz>0))rmsstat=RMS$_NORMAL;
	}
    else
	rmsstat=0;  /* Indicate ibb &| rbp not allocated */
    if(rsiz)*rsiz=rksiz;    /* Return Read Size */
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      RMS I/O FLUSH Routine.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rflush(rbp);
**
**
**  IMPLICIT INPUTS:
**
**      rbp = Record Access Block Pointer
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      Return RMS I/O Status
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rflush(rbp)
struct RAB *rbp;
{
    struct INTBUF *ibb;
    long osiz;
    unsigned long rmsstat = RMS$_NORMAL;

    ibb=rbp->rab$l_ctx;	/* set ibb pointer */
    osiz=(ibb->obsz)-(ibb->obr);
    if(osiz>0)
	{
	    rmsstat=rwrite(rbp,ibb->obs,osiz,0);
	    ibb->obp=ibb->obs;	/* Reset output pointer */
	    ibb->obr=ibb->obsz;	/* Set Remaining size */
	};
    return rmsstat;
}
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Buffered Sequential Write Routine for rwrite.
**
**  FORMAL PARAMETERS:
**
**      unsigned long rswrit(rbp,rec,siz)
**
**	struct RAB *rbp; - Record Access Block.
**	char *rec; - Record to Read.
**	unsigned short siz; - Size of Record to Read.
**
**  IMPLICIT INPUTS:
**
**      none
**
**  IMPLICIT OUTPUTS:
**
**      none
**
**  FUNCTION VALUE:
**
**      RMS I/O Completion Status.
**
**  SIDE EFFECTS:
**
**      none
**
**--
**/
unsigned long	rswrit(rbp, rec, siz)
struct RAB *rbp;
char *rec;
unsigned short siz;
{
    register unsigned char	*sbf,*dbf;
    unsigned long rmsstat = 1;
    short csiz,osiz,minsiz;
    struct INTBUF *ibb;

    sbf=rec;		    /* Set Source Address */
    csiz=siz;		    /* Set Initial Size to XFER. */
    if((rbp!=0) && ((ibb=rbp->rab$l_ctx)!=0)) /* DO I/O if rbp & ibb != 0 */
	{
/* INTBUF(ibb) POINTER SET */
	    while ((rmsstat & 1) && csiz>0)
		{
		    if((rmsstat & 1) != 0)
			{
			    if(ibb->obr <= 0)	/* flush out buffer */
				rmsstat=rflush(rbp);
			    else
				{

				    minsiz=(csiz <= (ibb->obr)) ?
					csiz : (ibb->obr);
				    csiz-=minsiz;
				    (ibb->obr)-=minsiz;

				    for (dbf=ibb->obp;minsiz>0;minsiz--)
					(*dbf++)=(*sbf++);
				    ibb->obp=dbf;/* Set Output Pointer */
				};
			};
		};
	}
    else
	rmsstat=0;  /* Indicate ibb &| rbp not allocated */
    return rmsstat;
}
/*[@function_definition@]...*/
