	SUBROUTINE RESLTNR (IDMS,NDIV)
C
C----------------------------------------------------------------------|
C
C THIS ROUTINE DETERMINES THE PLOT RESOLTION NDIV
C THE PLOT RESOLUTION VARIES FROM 60 TO 180 SCAN LINES
C  WRITTEN BY J.L.GREEN JAN 27 1982
C  UPDATED JFE JOHNSON 11 FEB 82
C
C RETURNS FOLLOWING NDIVS FOR IDMS (MS) IN FOLLOWING RANGES
C    IDMS LT 30 MINUTES   NDIV=60
C    IDMS LT 60 MINUTES   NDIV=120
C    IDMS GE 60 MINUTES   NDIV=180
C
C----------------------------------------------------------------------|
C                                                                      |
C      MODIFIED BY     R.L.WEST     INTERGRAPH      4-DEC-1984         |
C               MODIFIED TO ALLOW USER TO CHANGE THE DEFAULT NDIV      |
C                                                                      |
C----------------------------------------------------------------------|
C
      INTEGER*2 NDIV,NDIV_SAVE
      REAL*8    IDMS,RMINS
      DATA      NTM/0/
C
      RMINS=IDMS/60000000.0D0
C
C THE RESOLUTION IS SIMILAR TO THE TIME SPAN OF THE PLOT
C IN MINUTES
C
      IF (RMINS .GE. 60.0D0) THEN
         NDIV=180
      ELSE IF (RMINS .GE. 30.0D0) THEN
         NDIV=120
      ELSE
         NDIV=60
      END IF
      CALL IASK (NDIV,' SUBPERIODS PER FRAME (STANDARD DEFAULT =)')
C
      RETURN
      END
