	SUBROUTINE REFANG(DEGSAM,EXPRAM)
C
C ROUTINE WHICH RETURNS THE SPIN RATE DEGSAM (DEG/SAMPLE) AND A
C REFERENCE ANGLE EXPRAM (DEG) OF THE RADIAL INSTRUMENT WITH RESPECT
C TO THE S/C VELOCITY VECTOR (-180 0 THRU 180.0, 0=VIEWING IN VELOCITY
C VECTOR DIRECTION).   EXPRAM IS MEASURED IN SAME SENSE AS SPACECRAFT
C SPIN PHASE ANGLE.
C
C V1.0 JFEJ	27 NOV 81
C V1.1 JFEJ     10 MAY 82 CORRECTED SENSE AND RANGE OF REFANG, USES /MAF1/
C
	INTEGER IDAT(2812)
	COMMON/MAF1/IDAT
	DATA SCPHI/30.0/
C
	DEGSAM=FLOAT(IDAT(20))*0.01/64.0
	EXPRAM=FLOAT(IDAT(23))*0.1
	EXPRAM=EXPRAM+SCPHI+720.0
	EXPRAM=AMOD(EXPRAM,360.0)
	IF(EXPRAM.GT.180.0)EXPRAM=EXPRAM-360.0
	RETURN
	END
