      SUBROUTINE PITCH(B,THETA,PHI,ALPHA)
C THIS ROUTINE CALCULATES THE PITCH ANGLE OF A PARTICLE FROM A UNIT
C DIRECTION DEFINED BY A THETA (POLAR ANG) AND A PHI (AZIMUTHAL ANG)
      DIMENSION B(3)
C 
C ALL INPUT AND OUTPUT ANGLES ARE IN DEGREES
C
      RADEG=3.14159/180.0
      THETAR=THETA*RADEG
      PHIR=PHI*RADEG
C STRIP OUT THE B FIELD COMPONENTS
      BX=B(1)
      BY=B(2)
      BZ=B(3)
      BMAG=SQRT(BX*BX+BY*BY+BZ*BZ)
C DIRECTION DOT BFIELD = DMAG*BMAG COS(ALPHA); 
C FIRST SOLVE FOR COS(ALPHA)
      UNITI=BX*SIN(THETAR)*COS(PHIR)
      UNITJ=BY*SIN(THETAR)*SIN(PHIR)
      UNITK=BZ*COS(THETAR)
      COSALP=(UNITI+UNITJ+UNITK)/BMAG
C
C CALCULATE THE PITCH ANGLE IN DEGREES
C ALPDR IS THE PITCH ANGLE OF THE DETECTOR IN RADIANS
C
      ALPDR=ACOS(COSALP)
      ALPDD=ALPDR/RADEG
      ALPHA=180.0-ALPDD
C
      RETURN
      END
