      FUNCTION IANGLN(DEGSAM,RAMANG,NANG,ISAMPL)
C
C ROUTINE CALCULATES AN ANGLE BIN INDEX IN THE RANGE 1 THROUGH NANG
C FOR SAMPLE NUMBER ISAMPLE (1 THRU 512 IN THE CURRENT MAF1 RECORD).
C INPUT ARGUMENTS (RETURNED BY CALL TO REFANG) ARE:
C DEGSAM - SPIN RATE IN DEGREES PER SAMPLE
C RAMANG - ANGLE OF RADIAL INSTRUMENT WITH RESPECT TO RAM
C NANG   - NUMBER OF ANGLE BINS INTO WHICH ONE SPIN (360 DEG) IS SPLIT
C ISAMPL - SAMPLE NUMBER IN RANGE 1 THRU 512.
C
C PART OF THE D.E. DATA ANALYSIS SOFTWARE.
C
C V1.0 JFEJ 25 JUL 82
C
      ANG=RAMANG+(ISAMPL-1)*DEGSAM
C OFFSET TO PUT CENTRE (1-NANG) IN RAM DIRECTION
      ANG=ANG+900.0
      ANG=AMOD(ANG,360.0)
      IANGLN=1+ANG*NANG/360.0
      IF(IANGLN.GT.NANG)IANGLN=NANG
      IF(IANGLN.LT.1)IANGLN=1
C
      RETURN
      END
