      SUBROUTINE FRASETR (KODE)
C
C-----------------------------------------------------------------------
C
C     Prompts for the duration of each frame, and uses this to calculate
C     the increment and duration of each subperiod.
C
C     Return KODE = -1, end of file on input
C                 =  0, correct input
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of original FRASET written by JFE JOHNSON
C-----------------------------------------------------------------------
C
      INTEGER*2 KODE,NDIV
C
      INTEGER*4 IFLAG,ITEMP(4)
C
      REAL*8    DUR,DUR1,FRAME_TIMES(4),INC,RUN_TIMES(4),
     *          STRIP_TIMES(4),TMPDIV
C
      COMMON    /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /DELUNS/LUNDAT,LUNIN,LUNOUT,
     *          /FRATMS/FRAME_TIMES,NDIV
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      KODE=0
      DO I=1,4
         FRAME_TIMES(I)=RUN_TIMES(I)
      END DO
C
C-----------------------------------------------------------------------
C     *** get the duration of each frame ***
C-----------------------------------------------------------------------
C
   25 CONTINUE
      WRITE (LUNOUT,50)
   50 FORMAT (' ENTER DURATION OF EACH FRAME (SECS), 0 IF SINGLE',
     *        ' FRAME: ',$)
      READ (LUNIN,*,END=99) DUR1
      DUR1=DUR1*1000000.0D0
      IF (DUR1 .LT. 0.0D0) THEN
         WRITE (LUNTO,'('' INVALID DURATION, MUST BE GREATER THAN OR ''
     *                  ''EQUAL TO 0(ZERO), REENTER.'')')
         GO TO 25
      END IF
C
C-----------------------------------------------------------------------
C     ***              duration specified as 0             ***
C     *** calculate duration from run start and stop times ***
C-----------------------------------------------------------------------
C
      IF (DUR1 .EQ. 0.0D0) CALL DIFTMSR (RUN_TIMES(3),RUN_TIMES(4),
     *                             RUN_TIMES(1),RUN_TIMES(2),IFLAG,DUR1)
C
C-----------------------------------------------------------------------
C     *** determine number of divisions ***
C     ***    define first subperiod     ***
C     ***      define first frame       ***
C-----------------------------------------------------------------------
C
      CALL RESLTNR (DUR1,NDIV)
      TMPDIV=FLOAT(NDIV)
      INC=DUR1/TMPDIV
      DUR=INC
      CALL ADDTM2R (STRIP_TIMES(1),STRIP_TIMES(2),DUR,
     *              STRIP_TIMES(3),STRIP_TIMES(4))
      CALL DEFFRAR (KODE)
      RETURN
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
   99 KODE=-1
      RETURN
      END
