      SUBROUTINE DIFTMSR (YD1,T1,YD2,T2,IFLAG,DMS)
C
C-----------------------------------------------------------------------
C
C     Computes YD1,T1 - YD2,T2 and gives the difference in microsecs.
C
C     IFLAG = Not used, but kept for compatibility with the original
C             version.
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original DIFTMS written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      INTEGER*4 IFLAG
C
      REAL*8    D,DMS,D1,D2,T1,T2,YD1,YD2,Y1,Y2
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      IFLAG=0
C
C-----------------------------------------------------------------------
C     *** YD1 = YD2 ***
C-----------------------------------------------------------------------
C
      IF (YD1 .EQ. YD2) THEN
         DMS=T1-T2
C
C-----------------------------------------------------------------------
C     *** YD1 <> YD2 ***
C-----------------------------------------------------------------------
C
      ELSE
         IY=YD1/1000.0D0
         Y1=IY
         D1=YD1-Y1*1000.0D0
         IY=YD2/1000.0D0
         Y2=IY
         D2=YD2-Y2*1000.0D0
C
C-----------------------------------------------------------------------
C        *** Y1 = Y2 ***
C-----------------------------------------------------------------------
C
         IF (Y1 .EQ. Y2) THEN
            D=D1-D2
            DMS=(T1-T2)+D*86400000000.0D0
C
C-----------------------------------------------------------------------
C        *** Y1 < Y2 ***
C-----------------------------------------------------------------------
C
         ELSE IF (Y1 .LT. Y2) THEN
            DO WHILE (Y2 .GT. Y1)
               Y2=Y2-1.0D0
               IF (DMOD(Y2,4.0D0) .EQ. 0.0D0) THEN
                  D2=D2+366.0D0
               ELSE
                  D2=D2+365.0D0
               END IF
            END DO
            D=D1-D2
            DMS=(T1-T2)+D*86400000000.0D0
C
C-----------------------------------------------------------------------
C        *** Y1 > Y2 ***
C-----------------------------------------------------------------------
C
         ELSE
            DO WHILE (Y1 .GT. Y2)
               Y1=Y1-1.0D0
               IF (DMOD(Y1,4.0D0) .EQ. 0.0D0) THEN
                  D1=D1+366.0D0
               ELSE
                  D1=D1+365.0D0
               END IF
            END DO
            D=D1-D2
            DMS=(T1-T2)+D*86400000000.0D0
         END IF
      END IF
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
