      SUBROUTINE DELUNS(LUNDAT,LUNIN,LUNOUT)
C
C-----------------------------------------------------------------------
C
C THIS ROUTINE ACTS AS INITIALISATION TO THE DE READ/WRITE
C PROGRAMS.   THIS MODULE WOULD BE I/O DEVICE DEPENDENT
C
C PART OF THE DE MAF1/MAF2 DATA PROCESSING SOFTWARE
C
C JFE JOHNSON 4 OCT 81
C            25 OCT 81 FILENAME ADDED TO COMMON /FILNAM/
C             6 NOV 81 TRY A SINGLE SWEEP READ
C             7 DEC 81 DELUNS COMMON FOR TI:, RESTRUCTURE
C             28 APR 82 CALLS LOGFIL FOR ACCOUNTING
C            27 JUL 82 INDIRECTION ADDED
C-----------------------------------------------------------------------
C
C     Modified by     BARRY LEE and R. L. WEST     BCSS     SEP-1989
C              Cleaned up a lot of unwanted and unnecessary code.
C              Added the default file decompression code.
C
C-----------------------------------------------------------------------
C
      BYTE      FILE(80),TYPE(4)
C
      INTEGER*2 IBUF(LBUF),JLUN,JUNIN,JUNOUT,LUNDAT,LUNIN,LUNOUT
C
      COMMON    /DELUNS/JLUN,JUNIN,JUNOUT
C
      DATA      JLUN/0/,IOPEN/0/
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      JUNIN=LUNIN
      JUNOUT=LUNOUT
      JLUN=LUNDAT
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
C
C=======================================================================
C=======================================================================
C
      ENTRY DEOPEN
C
C-----------------------------------------------------------------------
C     open the maf1/2 data file
C-----------------------------------------------------------------------
C
   49 WRITE (JUNOUT,50)
   50 FORMAT ($,' Input data filename (press RETURN for default) >')
      READ (JUNIN,51,END=98) N,(FILE(I),I=1,N)
   51 FORMAT (Q,80A1)
      IF (N .EQ. 0) THEN
         IOPEN=0
      ELSE
         IF (N. LT. 80) FILE(N+1)=0
         OPEN (UNIT=JLUN,TYPE='OLD',NAME=FILE(1),FORM='UNFORMATTED',
     *         READONLY,ERR=99)
         IOPEN=1
      END IF
      RETURN
C
C-----------------------------------------------------------------------
C     *** could not find the MF1 file specified ***
C-----------------------------------------------------------------------
C
   99 WRITE (JUNOUT,52)
   52 FORMAT(' DEOPEN -- ERROR DURING OPEN - VOLUME MOUNTED ?')
      GO TO 49
C
C-----------------------------------------------------------------------
C     *** stop execution of the program ***
C-----------------------------------------------------------------------
C
   98 CALL EXIT
      STOP
C
C=======================================================================
C=======================================================================
C
      ENTRY REDDAT(IBUF,LBUF,IER)
C
C-----------------------------------------------------------------------
C     *** see if data read unit number has been specified ***
C-----------------------------------------------------------------------
C
   10 IER=0
      IF (JLUN .EQ. 0) THEN
         TYPE '('' Must specify a unit to read the data, usually 1'')'
         GO TO 98
      END IF
C
C-----------------------------------------------------------------------
C     *** if no data file has been specified get the one based  ***
C     *** on the run start and stop time in the commom /COMTMS/ ***
C-----------------------------------------------------------------------
C
      IF (IOPEN. EQ. 0) THEN
         CALL DECOM_OPEN_MAF1 (JLUN,ISTAT)
         IF (ISTAT .GT. 0) GO TO 20
         IF (ISTAT .LT. 0) GO TO 99
         IOPEN=2
      END IF
C
C-----------------------------------------------------------------------
C     *** read the data ***
C-----------------------------------------------------------------------
C
      READ (JLUN,END=20) IBUF
      RETURN
C
C-----------------------------------------------------------------------
C     *** finished with this data file ***
C-----------------------------------------------------------------------
C
C-----------------------------------------------------------------------
C     *** if using default data files get the next one based on ***
C     ***   the run start and stop time in the commom /COMTMS/  ***
C-----------------------------------------------------------------------
C
   20 IF (IOPEN .EQ. 2) THEN
         IOPEN=0
         GO TO 10
      END IF
C
C-----------------------------------------------------------------------
C    *** file was specified so close it ***
C-----------------------------------------------------------------------
C
      IER=-10
      TYPE *, ' NO MORE DATA'
      CLOSE(UNIT=JLUN)
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
C
C=======================================================================
C=======================================================================
C
      ENTRY REWDED
C
C-----------------------------------------------------------------------
C     *** rewind the dataset ***
C-----------------------------------------------------------------------
C
      REWIND JLUN
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
C
C=======================================================================
C=======================================================================
C
      ENTRY DECLOS
C
C-----------------------------------------------------------------------
C     *** close data set ***
C-----------------------------------------------------------------------
C
      IF (IOPEN .NE. 0) CLOSE(UNIT=JLUN)
      IOPEN=0
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
