/******************************************************************************
                          dealias.cpp  -  description
                             -------------------
    begin                : Tue Jul 24 18:41:00 CET 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

    Cluster-II EDI: function to de-alias difference between time tags

******************************************************************************
$Id: dealias.cpp,v 1.5 2002/07/16 08:51:54 hav Exp $
$Log: dealias.cpp,v $
Revision 1.5  2002/07/16 08:51:54  hav
added #include <stdlib.h> for exit()

Revision 1.4  2001/09/28 11:31:57  hav
now BM2 is also allowed

Revision 1.3  2001/07/25 16:09:56  hav
added dummy instruction to avoid compiler warning

Revision 1.2  2001/07/25 16:07:55  hav
added rcsid

Revision 1.1  2001/07/25 15:23:57  hav
Initial revision

******************************************************************************/


/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <stdlib.h>
#include "dealias.h"

/******************** CONSTANTS AND MACROS **********************************/


/******************** TYPE DEFINITIONS **************************************/


/******************** FUNCTION PROTOTYPES ***********************************/


/******************** GLOBAL STATIC DATA ************************************/

/******************** LOCAL STATIC DATA *************************************/

static int debug = 0;
static char rcsid[] = "$Id: dealias.cpp,v 1.5 2002/07/16 08:51:54 hav Exp $";

/******************** FUNCTION DEFINITIONS **********************************/

/*==========================================================================*/
  void DeAliasSetDebug(int dbg)
/*==========================================================================*/
{
   debug = dbg;
   if (0) printf("%s\n", rcsid); // dummy instruction
}

/*===========================================================================*/
short
DeAlias (unsigned short tmr_tt, unsigned short data_tt,
         short submo, short pacmo)
/*===========================================================================*/
{
   long x = -16;                // left boundary of allowed range
   long y;
   long delta;
   int i;

   long offs[] = { 0, -2048, 2048, -63488, -65536 };

   int nel = sizeof (offs) / sizeof (*offs);

   if ( (submo==1 || submo==2 || submo==3 || submo==6)  && pacmo==1 )
      y = 272;
   else if ( (submo==1 || submo==2 || submo==3 || submo==6) && pacmo==5 )
      y = 528;
   else if (submo == 5 && pacmo == 1)
      y = 80;
   else {
      fprintf (stderr, "DeAlias(): invalid sub/pack mode: %hd %hd\n",
               submo, pacmo);
      fflush (stderr);
      exit (1);
   }

   delta = data_tt - tmr_tt;

   for (i = 0; i < nel; ++i) {
      if (delta >= (x + offs[i]) && delta <= (y + offs[i]))
         break;
   }

   if (i == nel) {
      if (debug) {
         fprintf (stderr, "DeAlias(): failed to dealias delta time tag\n"
                  "tmr_tt=%04hx   data_tt=%04hx\n", tmr_tt, data_tt);
      }
      delta = INVALID_TT;
   }
   else {
      delta = delta - offs[i];
   }

   return (short) delta;

}
