/******************************************************************************
                           cl2tm.cpp  -  description                        
                             -------------------                              
    begin                : Jun 07 14:00 CET 2001
                                           
    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching 

    Wrapper for Libraries cdds and scsdmp

*****************************************************************************
$Id: cl2tm.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $
*****************************************************************************
$Log: cl2tm.cpp,v $
Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.7  2002/01/23 11:03:24  hav
new function CL2TM_GetScId()

Revision 1.6  2001/11/21 09:29:05  hav
new file type RDM in CL2TM_ReadData()

Revision 1.5  2001/11/12 17:31:09  hav
added RDM file support

Revision 1.4  2001/09/12 12:05:05  hav
enhanced CL2_ReadData to work for MSF files

Revision 1.3  2001/07/26 16:01:43  hav
new function CL2TM_GetFileType(), get file type from CDDS library after calling CDDS_OpenFile()

Revision 1.2  2001/07/25 15:18:32  hav
added rcsid

Revision 1.1  2001/07/25 14:50:58  hav
Initial revision

******************************************************************************/

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cl2tm.h"
#include "cdds.h"
#include "scsdmp.h"

/******************** CONSTANTS AND MACROS ***********************************/


/******************** TYPE DEFINITIONS **************************************/


/******************** FUNCTION PROTOTYPES ***********************************/


/******************** GLOBAL STATIC DATA ************************************/

/******************** LOCAL STATIC DATA *************************************/

static int FileType;
static int DataType;
static char rcsid[] = "$Id: cl2tm.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $";


/******************** FUNCTION DEFINITIONS ***********************************/


// ===========================================================================
   void CL2TM_OpenFile(const char *fn)
// ===========================================================================
// ***************************************************************************
{
 if (0) printf("%s\n", rcsid); // dummy instruction

 char *fname = "CL2TM_OpenFile()";

 if (FileType) return; // file already open

  // need to find out the data file type
  char *dotp = strrchr(fn, '.');
  if (dotp==NULL) {
     fprintf(stderr, "%s : no dot in passed filename <%s>\n",
                     fname, fn);
     exit(1);
  } else {
     char *extbuf = new char [strlen(dotp)];
     if (extbuf==NULL) {
        fprintf(stderr, "%s : ext buffer allocation failed\n", fname);
        exit(1);
     } else {
        strcpy(extbuf, dotp+1);
        for (unsigned int i=0; i<strlen(extbuf) ; ++i )
           extbuf[i] = tolower(extbuf[i]);
        if (strcmp(extbuf, "dmp") == 0) {
           FileType = FILE_TYPE_SCSDMP;
        } // other file types are determined in CDDS_OpenFile()
     }
     delete [] extbuf;
  }

  if (FileType == FILE_TYPE_SCSDMP) {
      SCSDMP_OpenFile(fn);
      DataType = SCSDMP_GetDataType();
  } else {
      CDDS_OpenFile(fn);
      FileType = CDDS_GetFileType();
      DataType = CDDS_GetDataType();
  }

}

// ===========================================================================
   void CL2TM_CloseFile(void)
// ===========================================================================
// ***************************************************************************
{
  switch (FileType)
  {
    case FILE_TYPE_SCSDMP : SCSDMP_CloseFile(); break;
    case FILE_TYPE_CDDS   : CDDS_CloseFile(); break;
  }
  FileType = 0; // tells the ...OpenFile() function that no file is open
}


// ===========================================================================
   void CL2TM_ReadData(FILE *ofp)
// ===========================================================================
// ***************************************************************************
{
  char *fname = "CL2TM_ReadData()";

  switch (FileType)
  {
    case FILE_TYPE_SCSDMP : SCSDMP_ReadReq(ofp); break;
    case FILE_TYPE_CDDS   :
    case FILE_TYPE_RDM    :
    case FILE_TYPE_MSF    : CDDS_ReadReq(ofp); break;
    default : fprintf(ofp, "%s : unknown file type! No action.\n", fname); break;
  }
}


// ===========================================================================
   int CL2TM_ReadPacket(tmpacket *tmptr)
// ===========================================================================
// ***************************************************************************
{
  int retval;
  char *fname = "CL2TM_ReadPacket()";

  switch (FileType)
  {
    case FILE_TYPE_SCSDMP : retval = SCSDMP_ReadPacket(tmptr); break;
    case FILE_TYPE_CDDS   :
    case FILE_TYPE_RDM    :
    case FILE_TYPE_MSF    : retval = CDDS_ReadPacket(tmptr); break;
    default : fprintf(stderr, "%s : unknown file type (%d)! No action.\n", 
                      fname, (int)FileType);
              retval=-1;
              break;
  }

  return retval;
}


// ===========================================================================
   int CL2TM_GetFileType() { return FileType; }
// ===========================================================================

// ===========================================================================
   int CL2TM_GetDataType() { return DataType; }
// ===========================================================================

// ===========================================================================
   int CL2TM_GetScId()
// ===========================================================================
{
  int retval;
  char *fname = "CL2TM_GetScId()";

  switch (FileType)
  {
    case FILE_TYPE_SCSDMP : retval = 0; break;
    case FILE_TYPE_CDDS   :
    case FILE_TYPE_RDM    :
    case FILE_TYPE_MSF    : retval = CDDS_GetScId(); break;
    default : fprintf(stderr, "%s : unknown file type! No action.\n", fname);
              retval=-1;
              break;
  }

  return retval;
}













