/******************************************************************************
                           cdds.h  -  description
                             -------------------
    begin                : Thu Sep 28 12:09:00 CET 2000

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2000 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

    Header file for cdds.cpp

******************************************************************************
$Id: cdds.h,v 1.2 2003/06/18 15:58:37 hav Exp $
$Log: cdds.h,v $
Revision 1.2  2003/06/18 15:58:37  hav
more development

Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.8  2002/05/28 07:30:24  hav
added function prototype for CDDS_PrintGroundStation()

Revision 1.7  2001/11/12 17:37:42  hav
new function CDDS_toRDM()

Revision 1.6  2001/07/26 16:03:10  hav
*** empty log message ***

Revision 1.5  2001/07/25 14:52:30  hav
some definitions moved in and out

Revision 1.4  2001/04/02 13:04:43  hav
*** empty log message ***

Revision 1.3  2001/02/21 22:55:31  hav
new structures to support binary transfer of data

Revision 1.2  2001/02/14 12:33:23  hav
common rcs format

*****************************************************************************/

#ifndef _CDDS_H_
#define _CDDS_H_

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include "cl2tm.h"

/******************** CONSTANTS AND MACROS ***********************************/


/******************** TYPE DEFINITIONS ***************************************/


/******************* FUNCTION PROTOTYPES ************************************/

void CDDS_OpenFile(const char *fn);
void CDDS_CloseFile(void);
void CDDS_ReadAck(FILE *ofp);
void CDDS_ReadCat(FILE *ofp);
void CDDS_ReadReq(FILE *ofp);
int  CDDS_ReadPacket(tmpacket *tmptr);
void CDDS_WritePacket(tmpacket tmpkt);
int  CDDS_GetScId(void);
int  CDDS_GetDataSource(void);
int  CDDS_GetDataType(void);
int  CDDS_GetFileType(void);
int  CDDS_toRDM(void);
void CDDS_PrintGroundStation(tmheader tmhdr);
char *CDDS_GroundStation(tmheader tmhdr);

#endif



