PRO read_fgm_cal, filename, range,  offsets,  matrix
openr,unit,filename,/get_lun

data = fltarr(4, 12)
readf, unit, data
close, unit
free_lun, unit

CASE range OF 
    2:BEGIN 
        offsets = reform(data(0, 0:2))
        matrix = reform(data(0, 3:11), 3, 3)
    END 
    3:BEGIN 
        offsets = reform(data(1, 0:2))
        matrix = reform(data(1, 3:11), 3, 3)
    END
    4:BEGIN 
        offsets = reform(data(2, 0:2))
        matrix = reform(data(2, 3:11), 3, 3)
    END 
    5:BEGIN 
        offsets = reform(data(3, 0:2))
        matrix = reform(data(3, 3:11), 3, 3)
    END
END 

END 


PRO roys_matrices

;file_path = '/home/austin/edi/pick/myidl/fgm_calibration/sc3/nov14/'
file_path = getenv('CL_MAG')
IF file_path EQ '' THEN BEGIN
    print, 'CL_MAG env variable is NOT set'
    stop
ENDIF

;read_fgm_dump, file_path+'bx_dump', bx
;read_fgm_dump, file_path+'by_dump', by
;read_fgm_dump, file_path+'bz_dump', bz

b = transpose([[bx],[by], [bz]])
;Convert to nT  range 2 divide by 32.
bx_nt = bx/32.
by_nt = by/32.
bz_nt = bz/32.


fit_sine, by, yamp, yphase, yoff, yspin
IF yphase LT 0. THEN yphase = 360. - abs(yphase)
fit_sine, bz, zamp, zphase, zoff, zspin
IF zphase LT 0. THEN zphase = 360. - abs(zphase)

IF zphase GT yphase THEN BEGIN 
    del_phase = 90.+ yphase - zphase
ENDIF ELSE BEGIN 
    del_phase = 90.+ zphase - yphase
ENDELSE 

phase_advance = [[1., 0., 0.], $
                 [0., cos(del_phase*!dtor), sin(del_phase*!dtor)], $
                 [0., -sin(del_phase*!dtor), cos(del_phase*!dtor)]]

rot6_5 = [[1., 0., 0.], $
          [0., cos(6.5*!dtor), sin(6.5*!dtor)], $
          [0., -sin(6.5*!dtor), cos(6.5*!dtor)]]
inv_rot6_5 = [[1., 0., 0.], $
              [0., cos(6.5*!dtor), -sin(6.5*!dtor)], $
              [0., sin(6.5*!dtor), cos(6.5*!dtor)]]
;rot1_5 = [[1., 0., 0.], [0., cos(1.5*!dtor), sin(1.5*!dtor)], [0., -sin(1.5*!dtor), cos(1.5*!dtor)]]

;Amplitude adjustment
a = 1
b = yamp/zamp
amplitude_adjust = [[1., 0., 0.], [0., a, 0.], [0., 0., b]]


;Read fgm matrix
range = 2
fgm_cal_file = pickfile(title = 'Select FGM calibration file:')
read_fgm_cal, fgm_cal_file, range, old_offsets, old_matrix

new_matrix =(phase_advance#(rot6_5#(amplitude_adjust#(inv_rot6_5#old_matrix))))

stop
END
  
