; ===========================================================================
  PRO readmag_cdm, Bx, Byt, Bzt, Bmag
; ===========================================================================
; reads magnetic field data from a beam reference table and plots it
; created: HAV
; ***************************************************************************

  ; flag for de-spinning
  ; ====================
  despin=1

  ; file name of beam reference table
  ; =================================
  brtfn = '/home/chutter/IBRT16.TS1';f:\tsim\brt\ibrt96.ts1'

  ; determine number of records
  ; ===========================
  nrecords = 0L
  brt_record_size = 120 

  ON_IOERROR, NULL
  OPENR, unit, brtfn, /GET_LUN
  fileinfo = FSTAT(unit)
  print, 'Filesize of ', brtfn, ' : ', fileinfo.size
  nrecords = fileinfo.size / brt_record_size
  FREE_LUN, unit
  print, 'Number of records = ', nrecords

  ; Read the data from the file and convert them to nT
  ; 4096 vectors per second
  ; ==================================================
  Bmag = read_cdm_mag_file(brtfn, 0, nrecords) * 1.0e-2          
  Bx   = read_cdm_mag_file(brtfn, 2, nrecords) * 1.0e-3 * Bmag
  By   = read_cdm_mag_file(brtfn, 4, nrecords) * 1.0e-3 * Bmag
  Bz   = read_cdm_mag_file(brtfn, 6, nrecords) * 1.0e-3 * Bmag


  ; Optional despinning
  ; ===================
  if despin eq 1 then begin
     time = indgen(nrecords)
     w_sc = 2*!PI/16384 ; 16384 GDU-frames per S/C spin (4 seconds)

     cos_wt = cos(w_sc*time)
     sin_wt = sin(w_sc*time)

     Byt =  By * cos_wt - Bz * sin_wt
     Bzt =  By * sin_wt + Bz * cos_wt
  endif else begin
     Byt = By
     Bzt = Bz
  endelse

  ; Reduction of time resolution : 256 vectors per seconds (1 vector / BCI)
                                ; --> pick every 204th vector (yes, it
                                ; is a strange number, but it procudes 
                                ; about 20 points per second which is
                                ; one of the options for Cluster
  ; =======================================================================
  xBCI = lindgen(nrecords/204) * 204

  Bmag = Bmag(xBCI)
  Bx   = Bx(xBCI)
  Byt  = Byt(xBCI)
  Bzt  = Bzt(xBCI)

END

