FUNCTION read_headers, mode_id, key_number, key_time
;
;  read_headers.pro
;
;  created by: Mark Chutter, UNH
;  Aug. 12, 1999
;
;  Modified:
;  Oct. 19, 1999 MWC used common block for structure definitions
;  Aug. 26, 2000 MWC don't try to unpack shdr if the packet is BM3
;  Sep. 22, 2000 MWC don't try to fill secondary header if RAM dump
;  Sep. 26, 2000 MWC now packets where sub_mode does not match
;                    packet_length are pitched
;  Sep. 27, 2000 MWC replaced bunch of IF IF-ELSE IF packet data
;                    mismatch
;  Dec. 12, 2000 MWC added MSF capability
;  Feb. 10, 2001 MWC added NM4; packet_type is now NM1 for NM2, NM3, NM4, BM2
;  Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                    addition of pacmo4
;  Jan. 14, 2002 MWC added amb_geos struct
;  Mar. 18, 2002 MWC add '15'x to list of valid science modes
;
;  Version: 0.
;
;  Calling Interface:
;  mode_id    P_LONG (i/o) Science Mode
;  key_number P_LONG (i/o) Packet Type Search Key
;  key_time   P_LONG (i/o) Packet Time Search Key

;  Return Value:
;  A sc_pick_headers_struct is returned which contains the EDI header
;  and EDI secondary header.  If the status field is less than zero,
;  then the structure is not valid.
;
;  Affected Variables:
;
;  Description:
;  If a specific packet
;  type is sought or key_number or key_time is set, it searches through the 
;  data file until an appropriate packet is found or the end of the file is 
;  reached.
COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct
COMMON pick, file_type, pick_lun
COMMON pick_buffer, pick_buffer, pick_buf_ptr
COMMON last_headers, last_headers

@pick_const

NM1_SIZE = 980
BM1_SIZE = 6944
BM2_SIZE = 992
BM3_SIZE = 23188

status = 0
packet_found = 0
packet_type = 0
right_mode = 0
packet_data_match = 0
good_data = -1
key_check = -1
tm_rate = 0
headers = sc_pick_headers_struct
headers_only = 1

; keep looking for a packet with good data of the type requested until
; one is found or eof
WHILE (good_data LT 1) DO BEGIN

    packet_data_match = 0

    CASE file_type OF
        'cdm':packet = cdm_get_packet(key_number, key_time, $
                                      file_type, pick_lun, /headers_only)
        'rdm':packet = rdm_get_packet(key_number, key_time, $
                                      file_type, pick_lun)
        'msf':BEGIN ;msf files contain 3 different packets for each time
            ;SC HK first
            sun_data = rdm_get_packet(key_number, key_time, $
                                      file_type, pick_lun)
            ;EDI HK second
            packet_hk = rdm_get_packet(key_number, key_time, $
                                       file_type, pick_lun)
            ;EDI SC third
            packet = rdm_get_packet(key_number, key_time, $
                                    file_type, pick_lun)
        END
        'ctm':packet = ctm_get_packet(key_number, key_time, $
                                      file_type, pick_lun)
    ENDCASE

    IF (packet.status EQ EOF) THEN BEGIN
;        headers = last_headers
        headers.status = EOF
        return, headers
    ENDIF

    ; try to read another packet if key conditions not met
    IF (packet.status LE 0) THEN BEGIN
        key_check = -1
    ENDIF ELSE key_check = 1

    IF (key_check GT 0) THEN BEGIN
        ; for EDI, determine the packet type
        IF file_type EQ 'ctm' AND packet.source LT 3 THEN $
          packet_type = PICK_HK_PACKET $
        ELSE IF (packet.source EQ PICK_EDI_PACKET) THEN BEGIN

            type = (packet.data[1] AND '7'x)
            CASE type OF
                0: packet_type = INVALID_EDI_DATA
                1: packet_type = SC_PICK_ENM1_PACKET
                2: packet_type = SC_PICK_ENM1_PACKET
                3: packet_type = SC_PICK_ENM1_PACKET
                4: packet_type = SC_PICK_ENM1_PACKET
                5: packet_type = SC_PICK_EBM1_PACKET
                6: packet_type = SC_PICK_ENM1_PACKET
                7: packet_type = SC_PICK_EBM3_PACKET
            ENDCASE

        ENDIF ELSE BEGIN
            print, $
              'The Pick Library can only be used for EDI packets.'
            return, NOT_EDI_PACKET
        ENDELSE

      ; When the mode_id is greater than 0 (for pickn_XX types),
      ; check to see if the current packet is of the desired type.
      ; If not, break and try again.

        right_mode = 0
        IF packet_type LE 0 THEN right_mode = 0 $ ;invalid data
        ELSE IF (mode_id EQ 0) THEN BEGIN ;any packet
            right_mode = 1
        ENDIF ELSE IF (mode_id GT 0) THEN BEGIN
            IF ((mode_id EQ PICK_SCI_PACKET) AND (packet_type GT 1)) THEN $
              right_mode = 1 $  ;any science mode
            ELSE IF ((mode_id EQ SC_PICK_ENM_PACKET) AND $
                     ((packet_type GT 10) AND (packet_type LT 20))) THEN $
              right_mode = 1 $
            ELSE IF ((mode_id EQ SC_PICK_EBM_PACKET) AND $
                     (packet_type GT 20)) THEN $
              right_mode = 1 $
            ELSE IF (mode_id EQ packet_type) THEN $
              right_mode = 1
        ENDIF
        
        size_check = n_elements(packet.data)
        IF file_type EQ 'cdm' THEN packet_data_match = 0 ELSE $
        IF packet_type EQ SC_PICK_ENM1_PACKET AND $
          size_check GT NM1_size+12 THEN BEGIN ;12 is for BM2
            packet_data_match = INVALID_EDI_DATA
        ENDIF ELSE IF packet_type EQ SC_PICK_EBM1_PACKET AND $
          size_check NE BM1_size THEN BEGIN
            packet_data_match = INVALID_EDI_DATA
        ENDIF ELSE IF packet_type EQ SC_PICK_EBM3_PACKET AND $
          size_check NE BM3_size THEN BEGIN
            packet_data_match = INVALID_EDI_DATA
        ENDIF

        IF (right_mode EQ 1) AND (packet_data_match EQ 0) THEN BEGIN

            ; fill the header
            hdr = edi_header_fill(packet.data[0:7], packet.packet_number, $
                                  packet.packet_time)

            IF hdr.status GE 1 THEN BEGIN

                ; check for valid science mode
                IF ((hdr.science_mode NE '1'x) AND $
                    (hdr.science_mode NE '2'x) AND $
                    (hdr.science_mode NE '5'x) AND $
                    (hdr.science_mode NE '8'x) AND $
                    (hdr.science_mode NE 'c'x) AND $
                    (hdr.science_mode NE 'd'x) AND $
                    (hdr.science_mode NE '11'x) AND $
                    (hdr.science_mode NE '13'x) AND $
                    (hdr.science_mode NE '15'x)) THEN BEGIN
                    hdr.status = INVALID_SCIENCE_MODE
                    
                ENDIF ELSE BEGIN

                    headers.hdr = hdr
                                ; fill the secondary header unless the
                                ; packet is a RAM dump
                    IF hdr.sub_mode NE '7'x AND $
                      hdr.mem_dump_bit LT 1 THEN BEGIN
                        shdr = edi_sec_header_fill(headers.hdr.science_mode, $
                                                   packet.data[8:39])

                        IF shdr.status GE 1 THEN BEGIN
                            headers.shdr = shdr
                            good_data = 1
                        ENDIF

                    ENDIF ELSE good_data = 1

                ENDELSE
            ENDIF               ; hdr.status
        ENDIF                   ; right_mode
    ENDIF                       ; key_check
ENDWHILE                        ; while (good_data < 1)

headers.status = packet_type
last_headers = headers
return, headers
END
