PRO rdm_get_packet_time, rdm_header, sec, usec
; CLUSTER II IDL Procedure
;
; Abstract: get the time for a RDM packet
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; Feb. 22, 2000 MWC had mismatched parentheses, changed calling
; Mar. 15, 2000 MWC now uses microseconds rather than milliseconds
;
; Calling Interface:
; rdm_header bytarr(15)  (i)   DDS Packet Header Buffer (i)
; sec        long        (i/o) seconds part of atime internal format 
;                              result-time (o)
; usec       long        (i/o) microsecond part of atime internal format 
;                              result-time (o)
;
; Return Value:
;
; Description:
; This routine reads the SCET Time Field from the header of the DDS packet.
; This header is described in the Cluster Data Delivery Interface Document.
; The first 8 bytes of the header contain the time since January 1, 1958.
; The first 2 bytes hold the number of days; the next 4 bytes contain the
; number of milliseconds within the day; the next 2 bytes contain the number
; of microseconds within the millisecond.  This 
; time is converted to the ctime used by the Pick Library.
;

time_zero = 4383l ;days from Jan. 1, 1958 to Jan. 1, 1970
milliseconds = 0l

;first convert number of days since Jan. 1, 1970 into number of
;seconds since Jan. 1, 1970, but does not account for leap seconds
sec = (long(rdm_header[0]) * '100'x + $
       long(rdm_header[1]) - time_zero) * 86400l

milliseconds = long(rdm_header[2]) * '1000000'x + $
  long(rdm_header[3]) * '10000'x + $
  long(rdm_header[4]) * '100'x + $
  long(rdm_header[5])

microseconds = long(rdm_header[6]) * '100'x + $
  long(rdm_header[7])
;add the number of seconds in the current day
sec = sec + (milliseconds/1000L)

;get the milliseconds within current second
usec = (milliseconds - (milliseconds/1000L) * 1000L) * 1000L + microseconds

END 
