FUNCTION pickst_hk, time_string, status 
; CLUSTER II IDL Procedure
;
; Abstract: Pick the EDI houseping data at the specified time
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; June 15, 1999
;
; Modified by:
; July 21, 1999 Mark Chutter added ctm; changed read_packet, replaced 
;                            CALL_EXTERNAL
; Apr. 21, 2000 Mark Chutter added msf file type
; Nov. 28, 2000 MWC now uses read_hk_packet rather than read_packet
;
; Calling Interface:
; time_string   char	(i)	Time at which to look for the data
; status	long	(o)	Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type EDI_HK
;
; Description:
; This function starts the read_XXX Module from the UNIX Pick Library
; and returns the received data in a structure.  XXX is one of RDM or CDM
;
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
;
; ...
; SR = PICKST_HK("1995-MAR-02 10:00:00.00",PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; help, /struct, sr
; ...
;	

COMMON pick_hk, hk_file_type, pick_hk_lun

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L

time_string = strupcase(time_string)
pick_cvt_str_sec, time_string, packet_time

IF hk_file_type EQ '' THEN print, 'File type not set'

CASE hk_file_type OF

    'cdm':pick_record = read_hk_packet(packet_num,  packet_time)

    'rdm':pick_record = read_hk_packet(packet_num,  packet_time)

    'msf':pick_record = read_hk_packet(packet_num,  packet_time)

    'ctm':pick_record = read_hk_packet(packet_num,  packet_time)

ENDCASE

return, pick_record

END  
