PRO pick_close
; CLUSTER II IDL Procedure
;
; Abstract: Close a PICK data file in use
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; modified: 
; Mar.  4, 1999 Mark Chutter added PICK_LIB environment variable
; Jul.  8, 1999 Mark Chutter replaced CALL_EXTERNAL
; Mar. 15, 2000 MWC close Spacecraft HK file if open
; Sep.  5, 2000 MWC make sure shk_lun is not -3 before trying to close 
;                   it.
; Sep. 15, 2000 MWC close mag file if one is open
;
; Version:  0.2
;
; Calling Interface:
;
; Return Value:
;
; Description:
; This function closes a data file initialized by a call of PICK_INIT.
;
; Example:
; 
; @PICK_SC_STRUCT
; 
; SNAME = 'ARCHIVE'
; FNAME = 'DMV1002.TM'
;
; ...
; PICK_INIT(SNAME,FNAME)
; status= PICKA_SC(sc_pick_id,PSTATUS)
; PICK_CLOSE
; ...
;
COMMON pick, file_type, pick_lun
COMMON shk, pick_shk_lun
COMMON mag_lun, pick_mag_lun
COMMON pick_hk, hk_file_type, pick_hk_lun

file_type = ''
IF (n_elements(pick_lun) GT 0) THEN BEGIN
    close, pick_lun
    free_lun, pick_lun
ENDIF

IF (n_elements(pick_hk_lun) GT 0) THEN BEGIN
    close, pick_hk_lun
    free_lun, pick_hk_lun
ENDIF

IF (n_elements(pick_shk_lun) GT 0) THEN BEGIN
    IF pick_shk_lun NE -3 THEN BEGIN
        close, pick_shk_lun
        free_lun, pick_shk_lun
    ENDIF
ENDIF
IF (n_elements(pick_mag_lun) GT 0) THEN BEGIN
    IF pick_mag_lun NE -3 THEN BEGIN
        close, pick_mag_lun
        free_lun, pick_mag_lun
    ENDIF
ENDIF

return
END
