FUNCTION nm1_pacmo0_fill, packet, hdr, dfgm, amb_geos, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo0 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; Aug.  9, 1999 MWC changed error field to status
; Aug.  9, 1999 MWC removed bic32_buf; just use index into packet for
;                   better performance
; Oct. 19, 1999 MWC used common block for structure definitions
; Nov. 21, 1999 MWC updated comments
; June 15, 2000 MWC added checks to make sure there is data before
;                   trying to fill
; July 20, 2000 MWC added dfgm_range
; Aug.  3, 2000 MWC fixed byte order of long words
; Aug. 25, 2000 MWC the compressed data should be unsigned; completely
;                   changed the way compressed data is extracted
; Sep. 26, 2000 MWC changed byte order of bcomp_0 and ch1 source
; Oct.  2, 2000 MWC looks like changing the byte order was not the solution
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added ambient GEOS
; Feb.  8, 2002 MWC energy and Bz_gz bytes were swapped; added amb
;                   GEOS time tag
; Mar. 11, 2002 MWC had the shift wrong on the perp bit in Amb Geos
; Apr. 29, 2002 MWC now nm1_pacmo0_fill gets hdr rather than hdr.chan0_comp
; July 16, 2002 MWC phi and theta in Ambient GEOS are now floats
; Oct. 23, 2002 MWC now use dealias_ag_time_tag to get ambient GEOS
;                   times
; Nov. 12, 2002 MWC added the "+1" for ambient GEOS time index; check
;                   status from dealias_ag_time_tag
; Nov. 18, 2002 MWC oops, I added 1 to the index, not the time index
; Nov.  3, 2004 MWC adjusted ambient timing by 0.03125
; Dec. 17, 2004 MWC added a check for direction flips in ambient
; Feb. 21, 2005 MWC added sc_id to nm1_pacmo0_fill and added check for
;                   time when perp bit was not properly set for
;                   ambient geos
; May  10, 2005 MWC D1 on SC3 started having a much lower response
;                   than D2 in 2005 intermittently.  If the average
;                   counts for D1 in a TMR are less than 1/5 than D2,
;                   the counts for D1 are set to a big negative number.
; May  25, 2005 MWC Rather than trying to determine intervals using
;                   the method above, Hans provided a list of
;                   intervals where dropouts occur.  The problem seems
;                   to have gone after a restart.
; Jul. 15, 2005 MWC D1 on SC2 had a strange response from June 27
;                   until July 1.  Data for this interval has been set
;                   to -999
; Jan. 13, 2005 MWC Sometime when people look at data, problems
;                   arise.  I misinterpreted the timing for ambient
;                   GEOS and shifted the times by one data time.
;
; Calling Interface:
; packet  bytarr              (i) EDI science packet
; hdr     sc_pick_ehdr_struct (i) EDI header structure
; dfgm    int                 (i) flag to show whether mode is Diagnositc FGM
;
; Return Value:
; A sc_pick_npacmo0_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_pacmo0_fill fills a nominal mode 1, pacmo 0 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

CH0_SIZE = 83
CH0_START = 46
CH1_SOURCE = 876
CH1_TIME_TAG = 880
CH1_BCI_CNT = 882
CH1_SIZE = 42
CH1_START = 884
SPARE_SIZE = 6
DFGM_DATA_FLAG_OFFSET = 40
DFGM_TIME_TAG_OFFSET = 42
DFGM_DATA_SIZE = 10
DFGM_CNT_OFFSET = 44
DFGM_DATA_OFFSET = 46
DFGM_RANGE_OFFSET = 880
AMB_GEOS_TIME_TAG_OFFSET = 42
AMB_GEOS_DATA_SIZE = 10
AMB_GEOS_CNT_OFFSET = 44
AMB_GEOS_DATA_OFFSET = 46
AMB_GEOS_RAM_OFFSET = 882
AMB_GEOS_ADDR_OFFSET = 908

chan0_comp = hdr.chan0_comp
pacmo0 = sc_pick_npacmo0_struct
pacmo0.status = 1
; If the mode is Diagnostic FGM, the data is packed differently.
IF (dfgm EQ 1) THEN BEGIN
    pacmo0.data_flag = fix(packet[DFGM_DATA_FLAG_OFFSET])
    pacmo0.dfgm_time_tag = long(packet[DFGM_TIME_TAG_OFFSET]) * '100'xL + $
      long(packet[DFGM_TIME_TAG_OFFSET+1])
    pacmo0.dfgm_count = fix(packet[DFGM_CNT_OFFSET]) * '100'x + $
      fix(packet[DFGM_CNT_OFFSET+1])

    IF pacmo0.dfgm_count GT 0 THEN BEGIN
        index = indgen(pacmo0.dfgm_count)
        offset = index * DFGM_DATA_SIZE + DFGM_DATA_OFFSET

        pacmo0.dfgm[index].b_z = fix(packet[offset[index]]) * '100'x + $
          fix(packet[offset[index]+1])
        pacmo0.dfgm[index].bcomp = fix(packet[offset[index]+2]) * '100'x + $
          fix(packet[offset[index]+3])
        pacmo0.dfgm[index].acc = fix(packet[offset[index]+4]) * '100'x + $
          fix(packet[offset[index]+5])
        pacmo0.dfgm[index].bcomp_0 = $
          long(packet[offset[index]+8]) * '1000000'xL + $
          long(packet[offset[index]+9]) * '10000'xL + $
          long(packet[offset[index]+6]) * '100'xL + $
          long(packet[offset[index]+7])
    ENDIF
    pacmo0.dfgm_range =  fix(packet[DFGM_RANGE_OFFSET]) * '100'x + $
      fix(packet[DFGM_RANGE_OFFSET+1])
ENDIF ELSE IF amb_geos EQ 1 THEN BEGIN
    IF hdr.science_mode NE '15'x THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF
    pacmo0.amb_geos_time_tag = $
      long(packet[AMB_GEOS_TIME_TAG_OFFSET]) * '100'xL + $
      long(packet[AMB_GEOS_TIME_TAG_OFFSET+1])

    time_tag_TMR = long(packet[8]) * '100'xL + long(packet[9])
    pacmo0.amb_geos_count = fix(packet[AMB_GEOS_CNT_OFFSET]) * '100'x + $
      fix(packet[AMB_GEOS_CNT_OFFSET+1])

    IF pacmo0.amb_geos_count GT 0 THEN BEGIN
        dealias_ag_time_tag, hdr, time_tag_TMR, pacmo0.amb_geos_time_tag, $
          btime, sc_id, status
        IF status LT 0 THEN BEGIN
            pacmo0.status = INVALID_EDI_DATA
            return, pacmo0
        ENDIF
        packet_time_d = double(btime[0]) + $
           double(btime[1]) * 1.D-6
        time_index = dindgen(pacmo0.amb_geos_count)
        index = indgen(pacmo0.amb_geos_count)
        pacmo0.amb_geos[index].time = packet_time_d + $
          (time_index * 32. + 16.) / 512.
        offset = index * AMB_GEOS_DATA_SIZE + AMB_GEOS_DATA_OFFSET
        pacmo0.amb_geos[index].theta = float(packet[offset[index]])*0.703125
        pacmo0.amb_geos[index].phi = float(packet[offset[index]+1])*2.8125
        pacmo0.amb_geos[index].energy = fix(packet[offset[index]+2])
        pacmo0.amb_geos[index].bz_gz = fix(packet[offset[index]+3] AND '01'x)
        pacmo0.amb_geos[index].b_perp = $
          ishft(fix(packet[offset[index]+3] AND '02'x), -1)
;a flag bit in TM was used for 2 functions from Oct. 2004 to
;Feb. 2005 in "perp" orbits.  The following if statements set the perp
;bit for this time range:
        IF (hdr.packet_time[0] GE 1098620891L AND $
            hdr.packet_time[0] LT 1098826151L) OR $
           (hdr.packet_time[0] GE 1099853650L AND $
            hdr.packet_time[0] LT 1100058850L) OR $
           (hdr.packet_time[0] GE 1100469910L AND $
            hdr.packet_time[0] LT 1100674990L) OR $
           (hdr.packet_time[0] GE 1100880850L AND $
            hdr.packet_time[0] LT 1101086110L) OR $
           (hdr.packet_time[0] GE 1101497230L AND $
            hdr.packet_time[0] LT 1101702310L) OR $
           (hdr.packet_time[0] GE 1102113490L AND $
            hdr.packet_time[0] LT 1102318690L) OR $
           (hdr.packet_time[0] GE 1102729810L AND $
            hdr.packet_time[0] LT 1102934830L) OR $
           (hdr.packet_time[0] GE 1103346190L AND $
            hdr.packet_time[0] LT 1103551450L) OR $
           (hdr.packet_time[0] GE 1103962510L AND $
            hdr.packet_time[0] LT 1104167590L) OR $
           (hdr.packet_time[0] GE 1104578890L AND $
            hdr.packet_time[0] LT 1104784090L) OR $
           (hdr.packet_time[0] GE 1105195210L AND $
            hdr.packet_time[0] LT 1105400290L) OR $
           (hdr.packet_time[0] GE 1105811830L AND $
            hdr.packet_time[0] LT 1106017030L) OR $
           (hdr.packet_time[0] GE 1106428150L AND $
            hdr.packet_time[0] LT 1106633350L) OR $
           (hdr.packet_time[0] GE 1107044710L AND $
            hdr.packet_time[0] LT 1107249960L) OR $
           (hdr.packet_time[0] GE 1107661150L AND $
            hdr.packet_time[0] LT 1107866350L) OR $
           (hdr.packet_time[0] GE 1108277950L AND $
            hdr.packet_time[0] LT 1108483090L) THEN $
          pacmo0.amb_geos[index].b_perp = 1

        pacmo0.amb_geos[index].flip = $
          ishft(fix(packet[offset[index]+3] AND '08'x), -3)
        pacmo0.amb_geos[index].zperp = fix(packet[offset[index]+4])
        pacmo0.amb_geos[index].yperp = fix(packet[offset[index]+5])
        pacmo0.amb_geos[index].data29_1 = $
          fix(packet[offset[index]+6]) * '100'x + $
          fix(packet[offset[index]+7])
        pacmo0.amb_geos[index].data29_2 = $
          fix(packet[offset[index]+8]) * '100'x + $
          fix(packet[offset[index]+9])

;On SC3 detector 1 started having a much lower response than detector
;2 on startup in 2005.
;start of dropout period   duration    comments
;-----------------------   --------    ---------------------------
;2005-03-23 17:00          36 min      starts at startup from quiescent
;2005-04-14 13:15          19 hrs      no cmds associated
;2005-04-19 14:50          10 min      starts at startup from standby
;2005-04-21 23:55          29 hrs      starts at startup from standby
;2005-04-26 13:30           7 hrs      ends at startup from standby
;2005-04-29 02:45          19 hrs      ends somewhere in WW
;2005-05-01 13:50          28 hrs      ends somewhere in WW
;2005-05-03 09:40         ~34 hrs      ends somewhere in WW
;2005-05-05 14:00          18.5 hrs    ends at startup form standby
;response of D2, the counts will be set to -999

        IF sc_id EQ 3 AND $
          (hdr.packet_time[0] GE 1111597200L AND $
           hdr.packet_time[0] LT 1111599360L) OR $
          (hdr.packet_time[0] GE 1113484500L AND $
           hdr.packet_time[0] LT 1113552900L) OR $
          (hdr.packet_time[0] GE 1113922200L AND $
           hdr.packet_time[0] LT 1113922800L) OR $
          (hdr.packet_time[0] GE 1114127700L AND $
           hdr.packet_time[0] LT 1114232100L) OR $
          (hdr.packet_time[0] GE 1114522200L AND $
           hdr.packet_time[0] LT 1114547400L) OR $
          (hdr.packet_time[0] GE 1114742700L AND $
           hdr.packet_time[0] LT 1114811100L) OR $
          (hdr.packet_time[0] GE 1114955400L AND $
           hdr.packet_time[0] LT 1115056200L) OR $
          (hdr.packet_time[0] GE 1115113200L AND $
           hdr.packet_time[0] LT 1115235600L) OR $
          (hdr.packet_time[0] GE 1115301600L AND $
           hdr.packet_time[0] LT 1115368200L) THEN $
          pacmo0.amb_geos[index].data29_1 = -999

;SC2 had a strange behavior from June 27, 2005 @17:00 to July 1, 2005
;@ 4:00.  Counts for D1 will be set to -999
        IF sc_id EQ 2 AND $
          (hdr.packet_time[0] GE 1119891600L AND $
           hdr.packet_time[0] LT 1120190400L) THEN $
          pacmo0.amb_geos[index].data29_1 = -999

    ENDIF

    index = indgen(4)
    offset = index * 2 + AMB_GEOS_RAM_OFFSET
    pacmo0.RAM_init[index] = uint(packet[offset[index]]) * '100'x + $
      uint(packet[offset[index]+1])
    index = indgen(8)
    offset = index * 4 + AMB_GEOS_ADDR_OFFSET
    pacmo0.addresses[index] = ulong(packet[offset[index]+2]) * '1000000'xUL + $
      ulong(packet[offset[index]+3]) * '10000'xUL + $
      ulong(packet[offset[index]]) * '100'xUL + $
      ulong(packet[offset[index]+1])
ENDIF ELSE BEGIN 

    pacmo0.ch0_data_word = long(packet[40]) * '100'xL + long(packet[41])
    pacmo0.ch0_time_tag = long(packet[42]) * '100'xL + long(packet[43])
    pacmo0.ch0_bci_cnt = fix(packet[44]) * '100'x + fix(packet[45])

    IF (pacmo0.ch0_bci_cnt GT CH0_SIZE) THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF

    IF (chan0_comp GT 0) THEN BEGIN
        IF pacmo0.ch0_bci_cnt GT 0 THEN BEGIN
            index = indgen(pacmo0.ch0_bci_cnt*8)
            comp_offset = intarr(8, pacmo0.ch0_bci_cnt)
            FOR i = 0, pacmo0.ch0_bci_cnt-1 DO BEGIN
                comp_offset[i*8:(i+1)*8-1] = indgen(8) + 10 * i + CH0_START
            ENDFOR
            comp_offset = reform(comp_offset, n_elements(comp_offset))
            pacmo0.ch0_comp[index] = uint(packet[comp_offset])
            FOR i = 0, pacmo0.ch0_bci_cnt-1 DO BEGIN
                index = indgen(8) + 8 * i
                range_offset = indgen(8)/4 + 10 * i + 8 + CH0_START
                pacmo0.ch0_range[index[0]] = $
                  ishft((packet[range_offset[0]] AND 'C0'x), -6)
                pacmo0.ch0_range[index[1]] = $
                  ishft((packet[range_offset[1]] AND '30'x), -4)
                pacmo0.ch0_range[index[2]] = $
                  ishft((packet[range_offset[2]] AND '0C'x), -2)
                pacmo0.ch0_range[index[3]] = $
                  packet[range_offset[3]] AND '03'x
                pacmo0.ch0_range[index[4]] = $
                  ishft((packet[range_offset[5]] AND 'C0'x), -6)
                pacmo0.ch0_range[index[5]] = $
                  ishft((packet[range_offset[6]] AND '30'x), -4)
                pacmo0.ch0_range[index[6]] = $
                  ishft((packet[range_offset[7]] AND '0C'x), -2)
                pacmo0.ch0_range[index[7]] = packet[9] AND '03'x
            ENDFOR
            decomp_data = new_decompress(pacmo0.ch0_comp)
            pacmo0.ch0_decomp = decomp_data
        ENDIF
    ENDIF ELSE BEGIN
        IF pacmo0.ch0_bci_cnt GT 0 THEN BEGIN
            index = indgen(pacmo0.ch0_bci_cnt*5)
            offset = CH0_START+2*index
            pacmo0.ch0_sample[index] = fix(packet[offset[index]]) * '100'x + $
              fix(packet[offset[index]+1])
        ENDIF
    ENDELSE
    
    pacmo0.ch1_source = $
      long(packet[CH1_SOURCE+2]) * '1000000'xL + $
      long(packet[CH1_SOURCE+3]) * '10000'xL + $
      long(packet[CH1_SOURCE]) * '100'xL + $
      long(packet[CH1_SOURCE+1])
    
    pacmo0.ch1_time_tag = long(packet[CH1_TIME_TAG]) * '100'xL + $
      long(packet[CH1_TIME_TAG+1])
    
    pacmo0.ch1_bci_cnt = fix(packet[CH1_BCI_CNT]) * '100'x + $
      fix(packet[CH1_BCI_CNT+1])
    
    IF (pacmo0.ch1_bci_cnt GT CH1_SIZE) THEN BEGIN
        pacmo0.status = INVALID_EDI_DATA
        return, pacmo0
    ENDIF

    IF pacmo0.ch1_bci_cnt GT 0 THEN BEGIN
        index = indgen(pacmo0.ch1_bci_cnt)
        offset = CH1_START+2*index
        pacmo0.ch1_data[index] = fix(packet[offset[index]]) * '100'x + $
          fix(packet[offset[index]+1])
    ENDIF

ENDELSE

return, pacmo0
END
