FUNCTION get_sun_data, file_type, packet_time
; CLUSTER II IDL Function
;
; Abstract: extract sun event data
;
; Created by: Mark Chutter, UNH 
; Aug. 13, 2000
;
; Modified:
; Feb.  1, 2001 MWC I think this problem was around for a long time.
;                   I assumed that it might have been user error until
;                   Barb complained.  Then I fixed it by golly.  I was
;                   not checking for EOF which would explain why a
;                   program could get stuck here.
;
; Calling Interface:
; file_type     string    (i) file type (RDM, CDM, etc.)
; packet_time   lonarr(2) (i) packet time search key
;
; Return Value:
; A 36 byte array containing the sun data is returned
;
; Description:

COMMON shk, pick_shk_lun
@pick_const

done = -1
status = 0
WHILE done LT 0 AND status NE EOF DO BEGIN

    IF file_type EQ 'rdm' THEN sun_data = rdm_get_sun_data(packet_time)
    status =  sun_data.status
    IF status EQ 1 THEN done = 1
    IF status EQ PACKET_TIME_HIGH THEN done = 1
ENDWHILE

return, sun_data

END
