PRO get_spin_ave_fgm, status
; CLUSTER II IDL Function
;
; Abstract: read magnetometer data file
;
; created by: Mark Chutter
; Sep. 13, 2000
;
; Modified: 
; Oct. 10, 2000 MWC FGM has Bz as spin axis, so it is stored in Bx;
;                   still need to finish this 
;
; Calling Interface:
;
; Return Value:
;
; Description:
; Read a magnetometer data file and extract data whose times
; lie between start_time and start_time + time_length

COMMON mag_lun, pick_mag_lun
COMMON spin_ave_fgm, spin_ave_fgm
@pick_const

status = 1
cnt = 0L
mag_t = 0.D

on_ioerror, eof

WHILE status GT 0 DO BEGIN
    readf, pick_mag_lun, mag_t, x, y, z
    spin_ave_fgm.mag_time[cnt] = mag_t
    spin_ave_fgm.bx[cnt] = z
    spin_ave_fgm.by[cnt] = x
    spin_ave_fgm.bz[cnt] = y
    cnt = cnt + 1L
ENDWHILE

eof: 
IF cnt GT 0 THEN BEGIN
    spin_ave_fgm.bmag = sqrt(spin_ave_fgm.bx*spin_ave_fgm.bx + $
                             spin_ave_fgm.by*spin_ave_fgm.by + $
                             spin_ave_fgm.bz*spin_ave_fgm.bz)
    spin_ave_fgm.status = cnt
ENDIF ELSE BEGIN
    status = FGM_ERROR
    spin_ave_fgm.status = FGM_ERROR
ENDELSE

END
