FUNCTION gdu_67_fill, vasec
; CLUSTER II IDL Function
;
; gdu_67_fill
;
; created by: Mark Chutter, UNH
; Aug. 16, 1999
;
; Modified:
; Sep.  1, 1999 I Made this much more useful by convert the hex
;               values to floats where needed.
; MWC Oct. 19, 1999 MWC added common block hk_structs
;
; Calling Interface:
; vasec  byte  (i)  raw GDU HK parameters from group 6 and 7
;
; Return Value:
; A filled sc_pick_gdu_67_struct
;
; Description:
; This file contains routines required to fill GDU HK
; parameters from Groups 6 and 7
COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct

gdu_67 = sc_pick_gdu_67_struct

gdu_67.i_el = float(fix(vasec[0]) * '100'x + fix(vasec[1])) * 0.028409
gdu_67.i_al = float(fix(vasec[2]) * '100'x + fix(vasec[3])) * 0.028409
gdu_67.i_oa = float(fix(vasec[4]) * '100'x + fix(vasec[5])) * 0.01116
gdu_67.i_sr = float(fix(vasec[6]) * '100'x + fix(vasec[7])) * 0.01116
gdu_67.i_sp = float(fix(vasec[8]) * '100'x + fix(vasec[9])) * 0.01116
gdu_67.i_ia = float(fix(vasec[10]) * '100'x + fix(vasec[11])) * 0.01116
gdu_67.i_rc = float(fix(vasec[12]) * '100'x + fix(vasec[13])) * 0.01116
gdu_67.i_et = float(fix(vasec[14]) * '100'x + fix(vasec[15])) * 0.01116
gdu_67.cfq1 = float(fix(vasec[16]) * '100'x + fix(vasec[17])) * 32.
gdu_67.cfq2 = float(fix(vasec[18]) * '100'x + fix(vasec[19])) * 32.
gdu_67.cfq3 = float(fix(vasec[20]) * '100'x + fix(vasec[21])) * 32.
gdu_67.cfq4 = float(fix(vasec[22]) * '100'x + fix(vasec[23])) * 32.
gdu_67.cfq5 = float(fix(vasec[24]) * '100'x + fix(vasec[25])) * 32.
gdu_67.cfq6 = float(fix(vasec[26]) * '100'x + fix(vasec[27])) * 32.
gdu_67.cfq7 = float(fix(vasec[28]) * '100'x + fix(vasec[29])) * 32.
gdu_67.cfq8 =float( fix(vasec[30]) * '100'x + fix(vasec[31])) * 32.

return, gdu_67 
END
