FUNCTION gd_fill, bci_buf, data_count, max_data_size, mode, sc_id, packet_time
; CLUSTER II IDL Function
;
; Abstract: fill an EDI gd data structure
;
; Created by: Mark Chutter, UNH 
; July  8, 1999
;
; Modified:
; Oct. 15, 1999 MWC working on efficiency: replaced all those
;                   multiplications: i*BPACMO1_DATA_SIZE with offset
;                   and tried to replace for loop with array syntax
; Oct. 19, 1999 MWC used common block for structure definitions
; Mar. 23, 2000 MWC uncommented gd declaration
; Apr. 28, 2000 MWC replaced for loop
; May   3, 2000 MWC RTFM, needed to multiply directions and ToF as per 
;                   manual; nnn was not completely procesed
; May   5, 2000 MWC Barb found the factor of 4 that was making ToF too 
;                   small.
; July 19, 2000 MWC correlator changes: the low 12 bits of word 14,
;                   max channel, and word 15 will be returned now
;                   rather than max channel/max counts and min
;                   channel/min counts
; Aug. 15, 2000 MWC words 14 and 15 are supposed to be unsigned
; Sep. 19, 2000 MWC swapped max_chans and words 14 and 15 until we
;                   figure out where the problem lies
; Sep. 20, 2000 MWC had wrong mask for nnn
; Sep. 21, 2000 MWC we figured out words 14 and 15
; Sep. 29, 2000 MWC changed words 14 and 15 and max channel according to
;                   TM change
; Sep. 29, 2000 MWC fixed conversion of word 14 to signed integer
; Oct. 11, 2000 MWC Barbs says that t1m2 should be multiplied by 16
;                   when the first bit is set
; Oct. 13, 2000 MWC Barb and I worked out the sign issue of t1m2
; Mar.  7, 2001 MWC TOF definition changed:
;                   SC3 session 0050 IPCH files 1240-1265  26-Feb 08:44 - 09:18
;                   SC1 session 0048 IPCH files 1188-1213  26-Feb 10:37 - 11:14
;                   SC2 session 0049 IPCH files 1214-1239  26-Feb 11:46 - 12:19
;                   SC4 : EDI is off
; Mar. 19, 2001 MWC new TOF code did not allow for case when data
;                   count is less than 329
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Apr.  4, 2001 MWC there seemed to be a overflow problem with the new
;                   t1 calculation, I converted quantities to longs,
;                   and it seems OK now
; Sep. 20, 2001 MWC qualities (sq1 and sq2) have been changed from
;                   byte to int type
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Feb. 25, 2002 MWC added overflow flags for ToF
; Feb. 27, 2002 MWC dtof_p_over was flagging -1
; June  5, 2002 MWC did not have enough bits for BM1 index
; Oct. 15, 2002 MWC negate sq2 for SC1
; Oct. 16, 2002 MWC set q=0 where gun voltages=0
;
; Calling Interface:
; bci_buf       bytarr  (i) buffer containing packet gd data
; data_count    int     (i) number of data collected
; max_data_size int     (i) maximum number of data in packet
; mode          int     (i) determines whether the packet is nominal 1, 
;                           pacmo 5 or burst 1, pacmo 1.
;
; Return Value:
; If the input requirements are met, a sc_pick_gd_struct structure
; is returned.  Otherwise an integer status is returned.
;
; Affected Variables:
;
; Description:
; gd_fill fills all the gd structures for a nominal 1, pacmo 5 or
; burst mode 1, pacmo 1 packet.  It is much more efficient this way in
; IDL as opposed to have a function that fills one gd structure at a
; time.  This is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

BPACMO1_DATA_SIZE = 20

new_TOF = 0

n_out = bytarr(8)
n_out = [1,2,4,8,8,16,32,64]

gd = replicate({sc_pick_gd_struct}, max_data_size) 

index = indgen(data_count)
offset = index * BPACMO1_DATA_SIZE

IF sc_id EQ 1 AND packet_time[0] GE 983179080L THEN $
  new_TOF = 1 ;'26-Feb-2001 09:18:00'
IF sc_id EQ 2 AND packet_time[0] GE 983186040L THEN $
  new_TOF = 1 ;'26-Feb-2001 11:14:00'
IF sc_id EQ 3 AND packet_time[0] GE 983189940L THEN $
  new_TOF = 1 ;'26-Feb-2001 12:19:00'

;need to know nnn for new TOF method
gd[index].nnn = n_out[ishft((bci_buf[offset[index]+6] AND '70'x), -4)]

IF new_TOF EQ 0 THEN BEGIN
    mult_check = intarr(data_count)
    mult_check[index] = bci_buf[offset[index]] AND '08'x
    sign = intarr(data_count)
    tmp = intarr(data_count)
    
    tmp = (long(bci_buf[offset[index]] AND '07'x) * '100'x + $
           long(bci_buf[offset[index]+1])) * 4 
;the 4 is in Barb's code, but not mentioned in the EDI User's Manual
    w = where(mult_check EQ 0, count)
    IF count GT 0 THEN gd[w].t1 = tmp[w]
    w = where(mult_check EQ 8, count)
    IF count GT 0 THEN gd[w].t1 = tmp[w] * 16L

    mult_check[index] = bci_buf[offset[index]] AND '80'x
    sign[index] = bci_buf[offset[index]] AND '40'x
    tmp = ishft(fix(bci_buf[offset[index]] AND '70'x), -4) * '100'x + $
      fix(bci_buf[offset[index]+2] AND 'F0'x) + $
      ishft(fix(bci_buf[offset[index]+4] AND 'F0'x), -4)

;t1m2 is signed
    w = where(sign EQ 64, count)
    IF count GT 0 THEN tmp[w] = tmp[w] - '800'x
    w = where(mult_check EQ 0, count)
    IF count GT 0 THEN gd[w].t1m2 = tmp[w]
    w = where(mult_check EQ 128, count)
    IF count GT 0 THEN gd[w].t1m2 = tmp[w] * 16
ENDIF 

IF new_TOF EQ 1 THEN BEGIN
    tmp = (long(bci_buf[offset[index]] AND '0F'x) * '100'x + $
           long(bci_buf[offset[index]+1])) 

    gd[0:data_count-1].t1 = tmp * gd.nnn
    w_o = where(tmp EQ 'FFF'x, count_o)
    IF count_o GT 0 THEN gd[w_o].tof_over = 1

;t1m2 is signed
    sign = bci_buf[offset[index]] AND '20'x
    tmp = ishft(fix(bci_buf[offset[index]] AND '10'x), -4) * '100'x + $
      fix(bci_buf[offset[index]+2] AND 'F0'x) + $
      ishft(fix(bci_buf[offset[index]+4] AND 'F0'x), -4)
    w_p = where(tmp EQ '1FF'x AND sign EQ '0'x, count_p)
    IF count_p GT 0 THEN gd[w_p].dtof_p_over = 1

    w_n = where(tmp EQ '000'x AND sign EQ '20'x, count_n)
    IF count_n GT 0 THEN gd[w_n].dtof_n_over = 1

    w = where(sign EQ '20'x, count)
    IF count GT 0 THEN tmp[w] = tmp[w] - '200'x

    gd[0:data_count-1].t1m2 = tmp * gd.nnn

    gd[index].m = ishft((bci_buf[offset[index]] AND 'C0'x), -6)
ENDIF

gd[index].vax1 = (fix(bci_buf[offset[index]+2] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+3])) * 8
gd[index].vay1 = (fix(bci_buf[offset[index]+4] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+5])) * 8
gd[index].vax2 = (fix(bci_buf[offset[index]+6] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+7])) * 8
gd[index].vay2 = (fix(bci_buf[offset[index]+8] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+9])) * 8
gd[index].sq1 = fix(ishft((bci_buf[offset[index]+8] AND 'C0'x), -6))
gd[index].sq2 = fix(ishft((bci_buf[offset[index]+8] AND '30'x), -4))

;rarely EDI gets gun voltages=0, but q > 0
w_1 = where(gd.vax2 EQ 0 AND gd.vay2 EQ 0 AND gd.sq1 GT 0, zero_1)
IF zero_1 GT 0 THEN gd[w_1].sq1 = 0
w_2 = where(gd.vax1 EQ 0 AND gd.vay1 EQ 0 AND gd.sq2 GT 0, zero_2)
IF zero_2 GT 0 THEN gd[w_2].sq2 = 0

gd[index].e = ishft((bci_buf[offset[index]+6] AND '80'x), -7)

;word 15 is ALL
gd[index].word15_1 = uint(bci_buf[offset[index]+12] AND '3F'x) * '100'x + $
  uint(bci_buf[offset[index]+13])
gd[index].word15_2 = uint(bci_buf[offset[index]+16] AND '3F'x) * '100'x + $
  uint(bci_buf[offset[index]+17])
;word 14 is SMAX +/-, only the lower 12 bits are used
gd[index].word14_1 = fix(bci_buf[offset[index]+10] AND '3F'x) * '100'x + $
  fix(bci_buf[offset[index]+11])
w = where((bci_buf[offset[index]+10] AND '20'x) GT 0, count)
IF count GT 0 THEN BEGIN
    gd[index[w]].word14_1 = gd[index[w]].word14_1 - '4000'x
ENDIF
gd[index].word14_2 = fix(bci_buf[offset[index]+14] AND '3F'x) * '100'x + $
  fix(bci_buf[offset[index]+15])
w = where((bci_buf[offset[index]+14] AND '20'x) GT 0, count)
IF count GT 0 THEN BEGIN
    gd[index[w]].word14_2 = gd[index[w]].word14_2 - '4000'x
ENDIF

; max_X and max_addrX are split because max_addrX corresponds to the
; channel number
gd[index].max_addr1 = ishft((bci_buf[offset[index]+10] AND 'C0'x), -4) + $
  ishft((bci_buf[offset[index]+12] AND 'C0'x), -6)
gd[index].max_addr2 = ishft((bci_buf[offset[index]+14] AND 'C0'x), -4) + $
  ishft((bci_buf[offset[index]+16] AND 'C0'x), -6)
;word 15 is ALL
;gd[index].word15_1 = uint(bci_buf[offset[index]+12]) * '100'x + $
;  uint(bci_buf[offset[index]+13])
;gd[index].word15_2 = uint(bci_buf[offset[index]+16]) * '100'x + $
;  uint(bci_buf[offset[index]+17])
;word 14 is SMAX +/-, only the lower 12 bits are used
;gd[index].word14_1 = uint(bci_buf[offset[index]+10] AND '0F'x) * '100'x + $
;  uint(bci_buf[offset[index]+11])
;gd[index].word14_2 = uint(bci_buf[offset[index]+14] AND '0F'x) * '100'x + $
;  uint(bci_buf[offset[index]+15])
; max_X and max_addrX are split because max_addrX corresponds to the
; channel number
;gd[index].max_addr1 = ishft((bci_buf[offset[index]+10] AND 'F0'x), -4)
;gd[index].max_addr2 = ishft((bci_buf[offset[index]+14] AND 'F0'x), -4)

gd[index].i1 = bci_buf[offset[index]+18] AND '3F'x
gd[index].i2 = bci_buf[offset[index]+19] AND '3F'x

gd[index].frame1 = ishft((bci_buf[offset[index]+18] AND 'C0'x), -6)
gd[index].frame2 = ishft((bci_buf[offset[index]+19] AND 'C0'x), -6)

;gun 1 on SC1 does not work
IF sc_id EQ 1 THEN gd.sq2 = -1 * gd.sq2
return, gd
END
