FUNCTION bm1_fill, packet, packet_number, packet_time, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI bm1 data structure
;
; Created by: Mark Chutter, UNH 
; Jul. 8, 1999
;
; Modified:
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; Jan. 20, 2000 MWC check return value from filling shdr
; June 12, 2000 MWC fill dmp_addr and big_mem_dmp if mem_dump_bit is set
; Aug.  3, 2000 MWC changed byte order of dump address
; Aug. 17, 2000 MWC added chan3_comp arg to bm1_pacmo0_fill
; Aug. 30, 2000 MWC now copy status from pacmo's into nm1.status
; Sep.  8, 2000 MWC put big_mem_dmp into mem_dmp - having 2 similar
;                                                  things was
;                                                  frustrating
; Sep. 12, 2000 MWC fixed spelling error
; Sep. 20, 2000 MWC RAM dump addresses are only 24 bit
; Sep. 25, 2000 MWC added packet size check - we were getting bogus
;                                             packets
; Nov. 13, 2000 MWC added sc_id to bm1_pacmo1_fill
; Dec. 22, 2000 MWC added raw_shdr
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4; also added bm1_pacmo4_fill
;                   call
; July 16, 2001 MWC added check of status from edi_header_fill; it used
;                   to be true that the status from the EDI header was
;                   always 1
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Jan. 16, 2002 MWC added ambient GEOS
; Oct. 24, 2002 MWC now bm1.hdr gets passed to bm1_pacmo0_fill
; Feb. 22, 2005 MWC added sc_id to bm1_pacmo0_fill
;
; Calling Interface:
; packet        bytarr    (i) EDI science packet
; packet_number long      (i) EDI packet number
; packet_time   lonarr(2) (i) time of EDI packet
;
; Return Value:
; A sc_pick_ebm1_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; bm1_fill fills a sc_pick_ebm1_struct data structure.  Depending on
; the packing mode of the packet, either a pacmo 0 or a pacmo 1 is filled;
; the other is present, but empty.  This is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

BM1_SIZE = 6944
RAW_SHDR_LOC = 8
MEM_DUMP_LOC = 40; byte offset for pacmo 0 memory dump
MEM_DUMP_SIZE = 143; number of 16 bit words
BIG_MEM_DUMP_OFFSET = 72
BIG_MEM_DUMP_SIZE = 3430
status = 0
valid = 0

bm1 = sc_pick_ebm1_struct
bm1.status = 1

size_check = n_elements(packet)
IF size_check NE BM1_SIZE THEN BEGIN
    bm1.status = INVALID_EDI_DATA
    return, bm1
ENDIF

; fill the header
hdr = edi_header_fill(packet, packet_number, packet_time)
IF hdr.status LT 0 THEN BEGIN
    bm1.status = hdr.status
    return, bm1
ENDIF

; make sure the packet is burst mode 1
IF (hdr.sub_mode NE 5) THEN BEGIN
    bm1.status = WRONG_TM_MODE
    return, bm1
ENDIF

; check for valid science mode
IF ((hdr.science_mode NE '1'x) AND $
    (hdr.science_mode NE '2'x) AND $
    (hdr.science_mode NE '5'x) AND $
    (hdr.science_mode NE '8'x) AND $
    (hdr.science_mode NE 'c'x) AND $
    (hdr.science_mode NE 'd'x) AND $
    (hdr.science_mode NE '11'x) AND $
    (hdr.science_mode NE '13'x) AND $
    (hdr.science_mode NE '15'x)) THEN BEGIN
    bm1.status = INVALID_SCIENCE_MODE
    return, bm1
ENDIF

bm1.hdr = hdr

bm1.raw_shdr = packet[RAW_SHDR_LOC:RAW_SHDR_LOC+31]

; depending on the packing mode, fill the proper pacmoX structure
IF bm1.hdr.mem_dump_bit GT 0 THEN BEGIN
    FOR i = 0, 15 DO BEGIN
        bm1.dmp_addr[i] = $
          long(packet[4*i+11]) * '10000'x + $
          long(packet[4*i+8]) * '100'x + $
          long(packet[4*i+9])
    ENDFOR
    FOR i = 0, BIG_MEM_DUMP_SIZE-1 DO BEGIN
        bm1.mem_dmp[i] = $
          fix(packet[2*i+BIG_MEM_DUMP_OFFSET]) * '100'x + $
          fix(packet[2*i+BIG_MEM_DUMP_OFFSET+1])
    ENDFOR
ENDIF ELSE BEGIN
; fill the secondary header which is meaningful only in non memory dump modes
    IF bm1.hdr.pacmo EQ 4 AND bm1.hdr.pga1_conf EQ 0 THEN BEGIN
        ;do nothing, pacmo4 has no secondary header until pga1 is configured
    ENDIF ELSE BEGIN
        packet_buf = packet[8:39]
        shdr = edi_sec_header_fill(bm1.hdr.science_mode, packet_buf)
        IF (shdr.status LT 0) THEN BEGIN
            bm1.status = shdr.status
            return, bm1
        ENDIF ELSE bm1.shdr = shdr
    ENDELSE

    CASE bm1.hdr.pacmo OF

        0:BEGIN
            dfgm = 0
            IF (hdr.science_mode EQ '11'x) THEN dfgm = 1
            amb_geos = 0
            IF (hdr.science_mode EQ '15'x) THEN amb_geos = 1
            pacmo0 = bm1_pacmo0_fill(packet, bm1.hdr, $
                                     dfgm, amb_geos, sc_id)
            bm1.pacmo0 = pacmo0
            bm1.status = pacmo0.status
            ; fill the mem_dump
            FOR i = 0, MEM_DUMP_SIZE-1 DO bm1.mem_dmp[i] = $
              packet[2*i+MEM_DUMP_LOC] * '100'x + $
              packet[2*i+MEM_DUMP_LOC+1]
        END

        1:BEGIN
            pacmo1 = bm1_pacmo1_fill(packet, bm1.hdr, sc_id)
            bm1.pacmo1 = pacmo1
            bm1.status = pacmo1.status
        END

        4:BEGIN
            pacmo4 = bm1_pacmo4_fill(packet, bm1.hdr.pga1_conf)
            bm1.pacmo4 = pacmo4
            bm1.status = pacmo4.status            
        END

    ENDCASE

ENDELSE

return, bm1
END
