/******************************************************************************
                          hkol.cpp  -  description                        
                             -------------------                              
    begin                : Fri Jan 26 15:43:00 CET 2001
                                           
    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2000 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

    Cluster-II EDI: scan CDDS EDI HKD files for current overlimit flags
******************************************************************************
$Id: hkol.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $
******************************************************************************
$Log: hkol.cpp,v $
Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.7  2001/08/10 11:31:29  hav
use ReadPacket instead of cl2dmp

Revision 1.6  2001/07/25 15:23:57  hav
*** empty log message ***

Revision 1.5  2001/04/02 13:01:13  hav
*** empty log message ***

Revision 1.4  2001/02/20 16:19:11  hav
new cdds library output format: filename in first line

Revision 1.3  2001/02/14 12:32:30  hav
common rcs format

******************************************************************************/


/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "cl2tm.h"

/******************** CONSTANTS AND MACROS ***********************************/

/******************** TYPE DEFINITIONS **************************************/

/******************** GLOBAL STATIC DATA ************************************/

/******************** LOCAL STATIC DATA *************************************/

static const char rcsid[] = "$Id: hkol.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $";

/******************** MAIN PROGRAM ******************************************/

// ===========================================================================
   int main(int argc, char *argv[])
// ===========================================================================
{
   FILE *ofp = stdout;
   tmpacket tmpkt;
   scet *tp=&(tmpkt.hdr.sc_time);

   short wd2;

   tmpkt.pktno = 0;

   if (0) printf("%s\n", rcsid); // dummy instruction

   if (argc!=2) {
      fprintf(stderr, "Usage: hkol filename\n");
      exit(1);
   }

   CL2TM_OpenFile(argv[1]);

   while (CL2TM_ReadPacket(&tmpkt) != -1) {

      if (tmpkt.hdr.data_source != CL2TM_DSRC_EDI ||
          tmpkt.hdr.data_type != CL2TM_HKD_DATA) {
         ++tmpkt.pktno;
         continue;
      }

      // check overlimit only if TM was not lost (LASTC != ffff)
      if (tmpkt.data[5]!=(short)0xffff) {
         if ( (tmpkt.data[2]&0xf000) != 0 ) {
            fprintf(ofp, "%04hd-%02hd-%02hdT%02hd:%02hd:%02hd : ",
                          tp->year, tp->month, tp->day,
                          tp->hr, tp->min, tp->sec);

            wd2 = tmpkt.data[2];

            if (wd2&0x1000) fprintf(ofp, "CNTL 28V overcurrent  ");
            if (wd2&0x2000) fprintf(ofp, "GDU1 overcurrent  ");
            if (wd2&0x4000) fprintf(ofp, "GDU2 overcurrent  ");
            if (wd2&0x8000) fprintf(ofp, "CNTL 5V overcurrent  ");
            fprintf(ofp, "\n");

        }

      }
      ++tmpkt.pktno;

   }

   CL2TM_CloseFile();

   return 0;
}












