function tick_ephem_spaux, axis, index, value

common tick_ephem_spaux_cb, t_ssm, radearth, rmag, maglat, lshell, invlat, local_time, cpaper, cim_survey, culf, mlt

common tick_ephem_spaux_cb2, gselat, gselong

; Round up to the nearest second
tup = long(t_ssm(index)+.5)

fh0 = double(tup)/3600d0
h0 =  long(fh0)
m0 =  long((fh0 - h0)*60d0)
s0 =  long(((fh0 - h0)*60d0 - m0)*60d0)

; Quick paper fix...I don't know my problem here...
if (s0 eq 59) then begin
    s0 = 0
    if (m0 eq 59) then begin
        m0 = 0
        h0 = h0+1
    endif else begin
        m0 = m0 + 1
    endelse
endif

tstr = string(h0,'(i2.2)')+':'+string(m0,'(i2.2)')+':'+string(s0,'(i2.2)')

rstr = string(rmag(index)/radearth,'(f5.2)')
lstr = string(lshell(index),'(f5.1)')
istr = string(invlat(index),'(f5.1)')
gselatstr = string(gselat(index),'(f5.1)')
maglatstr = string(maglat(index),'(f5.1)')

if (keyword_set(culf)) then fh0 = mlt(index)/3600. else fh0 = local_time(index)/3600.
h0 =  long(fh0)
m0 =  long((fh0 - h0)*60d0)
ltstr = string(h0,'(i2.2)')+':'+string(m0,'(i2.2)')

sout = tstr+'!c'+rstr+'!c'+lstr+'!c'+istr+'!c'+ltstr

; Paper specific
if (keyword_set(cpaper)) then $
  sout = strmid(tstr,0,5)+'!c'+rstr+'!c'+ltstr+'!c'+gselatstr+'!c'+istr

if (keyword_set(cim_survey)) then $
  sout = strmid(tstr,0,5)+'!c'+ltstr+'!c'+rstr+'!c'+maglatstr+'!c'+lstr+'!c'+istr

return, sout
end
