pro test_tick_ephem_spaux

date = '20010223'
scnum = '1'

; User-specified times
time = findgen(86400)           ; 'ssm' units (seconds since midnight)

; Get data for the plot
istat = spaux_info(scnum,time,'ssm',date=date,invlat=invlat)

xtickv = [19.,19.5,20.,20.5,21.,21.5,22.]*3600. ; ssm
_extra = {xrange:[19,22]*3600., $
          xtickv:xtickv,xticks:n_elements(xtickv)-1,xminor:4}

window, 0, xsize=700, ysize=900
!p.multi = [0,1,2]
!x.omargin = [10,5]
!y.omargin = [10,5]

xdat = time
ydat = invlat

; Regular plot
plot, xdat, ydat, _extra=_extra

; To plot using xtickformat='tick_ephem_spaux'
; you must follow these two steps:
prep_tick_ephem_spaux, scnum, xtickv, 'ssm', date=date
plot, xdat, ydat, _extra=_extra, xtickformat='tick_ephem_spaux'

return
end
