PRO TERMS2_INIT
;
; get terms2 data by definitions in IDL
;

COMMON TABLE,  NSYS,DEFS,TSYS,SYSCODE
  
;print,'TERMS2_INIT:  initializing TABLE data'

nsys = 11

tsys = ['Geographic (geocentric)        ',     $
        'Geographic (geodetic)          ',     $ 
        'Geocentric Solar Ecliptic      ',     $
        'Geocentric Solar Magnetospheric',     $
        'Solar Magnetic                 ',     $
        'Geomagnetic                    ',     $
        'Geocentric Equatorial Inertial ',     $
        'Heliocentric Aries Ecliptic    ',     $
        'Heliocentric Earth Ecliptic    ',     $
        'Heliocentric Earth Equatorial  ',     $
        'Geocentric Solar Equatorial    ']

defs = intarr(7,nsys)
defs[*,*] = [ [3,  -1,   3,   2,   0,  0,  0],   $
              [-1,  0,   0,   0,   0,  0,  0],   $
              [0,   0,   0,   0,   0,  0,  0],   $
              [1,  -4,   0,   0,   0,  0,  0],   $
              [2,  -5,  -4,   0,   0,  0,  0],   $
              [5,  -6,  -7,  -1,   3,  2,  0],   $
              [2,   3,   2,   0,   0,  0,  0],   $
              [1,   2,   0,   0,   0,  0,  0],   $
              [1,  12,   0,   0,   0,  0,  0],   $
              [4,   2,  -8,  -9, -10,  0,  0],   $
              [6,   2,  -8,  -9, -10, 11, 12]  ]


syscode = ['GEOC',    $
           'GEOD',    $
           ' GSE',    $
           ' GSM',    $
           '  SM',    $
           ' MAG',    $
           ' GEI',    $
           ' HAE',    $
           ' HEE',    $
           'HEEQ',    $
           'GSEQ'    ]
syscode =  strupcase(strtrim(syscode,2))

          return
END
