pro prep_tick_ephem_spaux, scnum, xtickv, ttype, date=date, $
                           paper=paper, im_survey=im_survey, $
                           spaux_path=spaux_path, t_st=t_st, ulf=ulf

common tick_ephem_spaux_cb, t_ssm, radearth, rmag, maglat, lshell, invlat, local_time, cpaper, cim_survey, culf, mlt

common tick_ephem_spaux_cb2, gselat, gselong

cpaper = keyword_set(paper)
cim_survey = keyword_set(im_survey)
culf = keyword_set(ulf)

if (ttype eq 'ssm') then begin
    istat = spaux_info(scnum,xtickv,ttype,date=date, $
                       radearth=re,rmag=r,maglat=m,lshell=l,$
                       invlat=i,local_time=lot,t_ssm=t, $
                       pgse=pgse, spaux_path=spaux_path, mlt=mlt)
    t_ssm = t
    radearth = re
    rmag = r
    maglat = m
    lshell = l
    invlat=i
    local_time=lot
    
    pmag = sqrt(total(pgse^2,1))
    gselat = asin(reform(pgse(2,*))/pmag)*!radeg
    gselong = atan(reform(pgse(1,*)),reform(pgse(0,*)))*!radeg
    
endif else if (ttype eq 'ssst') then begin

; Are we crossing a day boundary?
    t_epoch = t_st + double(xtickv*1.d+3)
    dates = strarr(n_elements(t_epoch))
    for i=0,n_elements(t_epoch)-1 do begin
        s = ep_time_handler(t_epoch(i),'epoch','vax_string')
        s = strmid(s,0,11)
        s = date2datevax(s,/reverse)
        dates(i) = s
    endfor
    iu = uniq(dates)
    
    if (n_elements(iu) gt 1) then begin
        message, 'Day Boundary', /cont
        
        if (n_elements(iu) ne 2) then message, 'Can only handle 1 day boundary'
        t_epoch0 = t_epoch(0:iu(0))
        t_epoch1 = t_epoch(iu(0)+1:n_elements(t_epoch)-1)
        
        istat0 = spaux_info(scnum,t_epoch0,'epoch', $
                           radearth=re0,rmag=r0,maglat=m0,lshell=l0,$
                           invlat=i0,local_time=lot0,t_ssm=t0, $
                           pgse=pgse0, spaux_path=spaux_path, mlt=mlt0)
        pmag0 = sqrt(total(pgse0^2,1))
        gselat0 = asin(reform(pgse0(2,*))/pmag0)*!radeg
        gselong0 = atan(reform(pgse0(1,*)),reform(pgse0(0,*)))*!radeg
        

        istat1 = spaux_info(scnum,t_epoch1,'epoch', $
                           radearth=re1,rmag=r1,maglat=m1,lshell=l1,$
                           invlat=i1,local_time=lot1,t_ssm=t1, $
                           pgse=pgse1, spaux_path=spaux_path, mlt=mlt1)
        pmag1 = sqrt(total(pgse1^2,1))
        gselat1 = asin(reform(pgse1(2,*))/pmag1)*!radeg
        gselong1 = atan(reform(pgse1(1,*)),reform(pgse1(0,*)))*!radeg

        radearth = re0
        
        t_ssm = [t0,t1]
        rmag = [r0,r1]
        maglat = [m0,m1]
        lshell = [l0,l1]
        invlat = [i0,i1]
        local_time = [lot0,lot1]
        pmag = [pmag0,pmag1]
        gselat = [gselat0,gselat1]
        gselong = [gselong0,gselong1]
        mlt = [mlt0,mlt1]

    endif else begin
        message, 'No Day Boundary', /cont
        
        istat = spaux_info(scnum,t_epoch,'epoch', $
                           radearth=re,rmag=r,maglat=m,lshell=l,$
                           invlat=i,local_time=lot,t_ssm=t, $
                           pgse=pgse, spaux_path=spaux_path, mlt=mlt)
        pmag = sqrt(total(pgse^2,1))
        gselat = asin(reform(pgse(2,*))/pmag)*!radeg
        gselong = atan(reform(pgse(1,*)),reform(pgse(0,*)))*!radeg

        radearth = re
        
        t_ssm = t
        rmag = r
        maglat = m
        lshell = l
        invlat = i
        local_time = lot
    endelse

endif else begin
    message, 'Can only handle "ssm" and "ssst"'
endelse



return
end
