; This is a partial control file for the 
; 'P'rime 'P'arameter (PP) generation software, edi_piso.pro
; The control parameters more likely to change are defined as
; environment variables in 'edi_piso_gcdc_script'.

;===============================================================
pp_eV2joule = 1.60219e-19       ; Electron volts to joules, multiplicative
pp_eV2erg = 1.60219e-12         ; Electron volts to ergs, multiplicative
pp_emass_mks = 9.10953e-31      ; Electron mass, kg
pp_deg2rad = !pi/180.           ; Degrees to radians, multiplicative
pp_clight_cgs = 3.e+10
pp_svpcm2mvpm = 3.e+4*1.e+3     ; statvolt/cm to mV/m, multiplicative
pp_nt2gauss = 1e-9*1e+4         ; nanotesla to gauss, multiplicative

pp_rfill = -1.e+31
pp_bfill = 255
pp_i4fill = 2147483647          ; 2^31 - 1
pp_i2fill = 32767

;eqs phase0 = 135.d0*!dpi/180.d0     ; 135 deg angle from GDU1 to
;eqs                                 ; the See-Sun axis (SSa),
;eqs                                 ; measured counterclockwise in the
;eqs                                 ; spin plane (i.e. in the direction of
;eqs                                 ; the spacecraft rotation) for EQS

pp_phase0 = 296.2d0*!dpi/180.d0 ; 296.2 deg angle from GDU1 to 
                                ; the See-Sun axis (SSa),
                                ; measured counterclockwise in the
                                ; spin plane (i.e. in the direction of
                                ; the spacecraft rotation) for Cluster

pp_sc_base = 3.20d0             ; Gun/Det. spacing of Cluster (approx)
                                ; Note that this ISN'T the radius of Cluster,
                                ; it's the diameter.  We use this just
                                ; like you would a radius when
                                ; we construct the gun positions
                                ; because the triangulation software
                                ; works with a virtual spacecraft
                                ; which is twice as big as Cluster.

pp_eindex2keV = [1.d0,0.5d0]    ; Energy in keV of the e_index=0 and 
                                ; e_index=1 energy levels

;============== PID DEFINITIONS (FYI) ====================
;pid = 1L                        ; EDI housekeeping data
;pid = 10L                       ; ALL Nominal Mode 1 EDI data
;                                ; (i.e. S/C modes 11,12,13 or 22)
;pid = 21L                       ; Burst Mode 1 EDI data
;pid = 23L                       ; Burst Mode 3 EDI data
;pid = 99L                       ; S/C housekeeping data
;=========================================================

; Expected value of packet_time - atime(1st subpacket of packet):
;         ptime - atime ~ 5.2s
pp_ptime_atime_offset = 5.2d0   ; Seconds
pp_hour_delta = 2.d0*pp_ptime_atime_offset ; Seconds, used to buffer
                                ; the hour time range

checkmsg_array = ['Valid Science Mode', $
                  'Science mode not equal to 5', $
                  'Sub-mode inconsistent with TM-mode', $
                  'RAM dump', $
                  'sn.pacmoN.data_count = 0 (not expected)', $
                  'NNN/COTYPE/SAMTYPE inconsistent', $
                  '7th bit of SOB inconsistent with e-switching', $
                  'Packet/sub-packet time anomoly', $
                  'SRT = 0', $
                  'TSPIN is unreasonable', $
                  'NM1, PACMO1 not yet handled by PICK/EDI_PISO']

;===============================================================
; Control parameters set in 'edi_piso_gcdc_script':
pp_gunid = long(getenv('pp_gunid'))
pp_nbeam_min = long(getenv('pp_nbeam_min'))
pp_qual_min = long(getenv('pp_qual_min'))
pp_maxchan_min = long(getenv('pp_maxchan_min'))
pp_maxchan_max = long(getenv('pp_maxchan_max'))
pp_maxorder = long(getenv('pp_maxorder'))
pp_outlier_removal = long(getenv('pp_outlier_removal'))
pp_cg_phires = float(getenv('pp_cg_phires'))*pp_deg2rad
pp_fg_phires = float(getenv('pp_fg_phires'))*pp_deg2rad
pp_acfir = float(getenv('pp_acfir'))*pp_deg2rad
pp_actof_con = float(getenv('pp_actof_con'))

;========IMPORTANT NOTE!!! IMPORTANT NOTE!!! IMPORTANT NOTE!!!======
; The following parameters are used in both whatech.pro.
; PLEASE note that THERE ARE STILL hardwired parameters
; in bestarg.pro THAT MIGHT NEED TO CHANGE IF THE PARAMETERS BELOW ARE
; CHANGED!!! I didn't have time to completely 'pp_control'-ize the
; whatech.pro and bestarg.pro codes.  So, DON'T CHANGE THE PARAMETERS
; BELOW UNLESS YOU FULLY UNDERSTAND ALL OF THE OTHER PARAMETERS STILL
; HARDWIRED IN THE BESTARG CODE!!!  PPQ, 14-Feb-2001, (Happy
; Valentine's Day).
;===================================================================
pp_tri_ang_thresh_1 = 4.2*pp_acfir ; radians 
                                ; At least one beam pair must have an angle
                                ; difference exceeding
                                ; pp_tri_ang_thresh_1 in order
                                ; for triangulation to be
                                ; well-behaved.  This ensures that at
                                ; least for this pair, the
                                ; triangulation point has a relative
                                ; error in distance of 1/3.

pp_tri_ang_thresh_2 = 2.1*pp_acfir ; radians
                                ; In addition to the condition stated
                                ; above, the average angle difference of all
                                ; of the beams must exceed 
                                ; pp_tri_ang_thresh_2 in
                                ; order for triangulation to be
                                ; well-behaved.

pp_tri_ang_thresh_3 = 6.5*pp_acfir ; radians
                                ; If the average angle difference of 
                                ; all of the beams exceeds 
                                ; pp_tri_ang_thresh_3, and
                                ; both ToF and Tri are well-behaved,
                                ; then pure triangulation is
                                ; preferred.

pp_tof_tdiff_thresh = sqrt(2.)  ; If the average ToF difference of all of
                                ; the beam pairs exceeds
                                ; pp_tof_tdiff_thresh*actof, then
                                ; ToF analysis is considered well-behaved.

pp_rmax_con = 3                 ; Used by whatech to determine appropriate grid size.


