; THIS CODE IS USED BY plot_bestarg.pro.
; See plot_bestarg.pro for documentation.
; No reason for user to ever interface with this code.
 
pro plot_ba, bestord, siz, plot_title, orbitx_bpp, orbity_bpp, bestarg_ok, errors, mb, out, xg, yg, gunid, alpha, xd, yd, mxch, plot_msg, eswathx_bpp, eswathy_bpp, font, survey, fname, ispin, charsize, ordmax=ordmax, xrange=xrange, yrange=yrange, thick=thick, cs=cs
;******************************************************************
;draw firing directions and a symbol at each gun location
;thick lines point to the target consistent with the respective tof
;******************************************************************
edi_setcolors, cs
!p.background = cs.white
!p.color = cs.black
font = '!6'

if (survey) then begin
    dot_symsize = 1.0
    symsize=.75
    xmargin = [5,5]
    ymargin = [5,5]
endif else begin
    dot_symsize = 1.5
    symsize=1.0
    xmargin = [7,7]
    ymargin = [7,7]
endelse

if n_elements(thick) ne 0 then begin
    thick_plot = thick
    thick_beam = thick
    thick_arrow = 2.*thick
endif else begin
    thick_plot = 1
    thick_beam = .1
    thick_arrow = 2
endelse

colors = [cs.black,cs.magenta,cs.orange,cs.green,cs.purple,cs.yellow]
cfilt = bestord
lines = [0,2]
syms = [2,5]

if (n_elements(ordmax) ne 0) then iordmax=ordmax else iordmax=n_elements(colors)

if (n_elements(xrange) eq 0) then xrange=[-siz,siz] else xrange=xrange
if (n_elements(yrange) eq 0) then yrange=[-siz,siz] else yrange=yrange
plot,	[0],[0],psym=1,xra=xrange,yra=yrange,$
  xsty=1,ysty=1,$
  xtit='x!dBPP!n [m]',ytit='y!dBPP!n [m]',$
  title=plot_title, xmargin=xmargin, ymargin=ymargin, $
  /nodata, charsize=charsize, thick=thick_plot

if (xrange(1)-xrange(0) ge 6.4 and $ ; Need to have enough room or the polyfill will cover up axes
    yrange(1)-yrange(0) ge 6.4) then $
  polyfill, orbitx_bpp, orbity_bpp, color=cs.grey80, /data

if (bestarg_ok and errors) then polyfill, eswathx_bpp, eswathy_bpp, color=cs.grey60, /data

;oplot,	[-siz,siz],[yd,yd],linestyle=3,color=cs.black,thick=2
;oplot,	[xd,xd],[-siz,siz],linestyle=3,color=cs.black,thick=2
;oplot, !x.crange,[0,0],line=1
;oplot, [0,0],!y.crange,line=1
xx=xrange

;dperps = 0.d0
;tof_ordered = dblarr(5)
;ntof_ordered = lonarr(5)
;ta_beam = intarr(mb)  ; Keep track of who's towards and who's away
;for im = 0, mb-1 do begin
; ta_beam(im) = -1
;; Keep track of tof by beam order
;  iorder = bestord(im)-1
;  tof_ordered(iorder) = tof_ordered(iorder) + tof(im)
;  ntof_ordered(iorder) = ntof_ordered(iorder) + 1
;; What is the distance (perpendicular to the beam) from
;; the beam to the target?
;  ghat = [cos(alpha(im)),sin(alpha(im))]
;  lvec = [xd-xg(im),yd-yg(im)] & lmag = sqrt(total(lvec^2,/double))
;  ghat_dot_lvec = total(ghat*lvec, /double)
;  ta_beam(im) = 0
;  if (ghat_dot_lvec lt 0.) then begin
;    ta_beam(im) = 1
;    ghat = -1.d0*ghat
;    ghat_dot_lvec = total(ghat*lvec, /double)
;  endif
;  beta = acos(ghat_dot_lvec/lmag)
;  dperp = lmag*sin(beta)
;  dum = sqrt(lmag^2 - dperp^2)
;  if (bestord(im) eq 1) then dperps = [dperps,dperp]
;endfor

; What is the gyro-period?
;tgyro_fgmbmag = 2.d0*!dpi*9.1d-31/1.6d-19/(sqrt(total(bfield_scs(0:2,ispin)^2))*1d-9)*1.d6
;tgyro_bestarg = tgyro(ispin)

;print, 'tgyro_fgmbmag: ', tgyro_fgmbmag
;print, 'tgyro_bestarg: ', tgyro_bestarg
;away = where(bestord eq 1 and ta_beam eq 1)
;towards = where(bestord eq 1 and ta_beam eq 0)

;if away(0) ne -1 then begin
;  print, 'Away Tofs: ', tof(away)
;  if (towards(0) ne -1) then begin
;  print, 'Towa Tofs: ', tof(towards)
;     for idum1 = 0, n_elements(away)-1 do begin
;      idum2 = where(abs(btime_ssm(towards) - btime_ssm(away(idum1))) lt .010)
;      if (idum2(0) ne -1) then print, 'A Synchro Hit: ', tof(away(idum1)), tof(towards(idum2)), tof(towards(idum2))-tof(away(idum1))
;     endfor
;  endif
;endif

;goto, skip_the_rest

;if n_elements(dperps) gt 1 then begin
;  dperps = dperps(1:n_elements(dperps)-1)
;  if (n_elements(dperps) gt 1) then dperps_mean = mean(dperps,/double) $
;     else dperps_mean = dperps(0)
;  ppphi = findgen(100)*2.*!pi/99.
;  errorcircle_x = dperps_mean*cos(ppphi) + xd
;  errorcircle_y = dperps_mean*sin(ppphi) + yd
;  polyfill, errorcircle_x, errorcircle_y, color=cs.grey80, /data
;  xyouts, .8, .1, string(dperps_mean/sqrt(xd^2+yd^2)*100.,'(f6.2)'), $
;    /normal
;endif

for im = 0, mb-1 do begin
    
; Manuscript example filter in order to get rid of the one triple runner...
;	if (colors(cfilt(im)-1) eq cs.black or $
;	    colors(cfilt(im)-1) eq cs.magenta) then begin
    
    case out(im) of
        0:color=colors(cfilt(im)-1)
        1:color=colors(cfilt(im)-1)
        2:color=cs.grey60       ; statistical outlier
        3:color=cs.grey60       ; order undetermined/class restriction
        4:color=cs.grey60       ; Unsuitable for PMT
        5:color=cs.grey60       ; Unsuitable for SMT
        6:color=cs.grey60       ; Unsuitable for RMT
        255:color=cs.grey60     ; Unsuitable
        else:message, 'Value of out(im) not known'
    endcase
    
    if (bestord(im) le iordmax) then begin
        oplot,[xg(im)],[yg(im)],psym=syms(gunid(im)-1), color=color, $
          symsize=symsize
        yy=tan(alpha(im)+1e-4)*(xx-xg(im))+yg(im)
        oplot,xx,yy,thick=thick_beam, color=color, line=lines(gunid(im)-1)
    endif
    
;	endif
    
; Where does each beam intersect the driftstep line?
;  slp1 = yd/xd & b1 = 0.
;  slp2 = tan(alpha(im)+1e-4) & b2 = yg(im) - tan(alpha(im)+1e-4)*xg(im)
    
;  xint = (b2 - b1) / (slp1 - slp2)
;  yint = slp1*xint + b1
    
;  oplot, xx, yd/xd*xx, line=0, color=cs.red, thick=3
;  oplot, [xint], [yint], psym=2, color=cs.red, symsize=2
    
; What is the distance (perpendicular to the beam) from
; the beam to the target?
;  ghat = [cos(alpha(im)),sin(alpha(im))]
;  lvec = [xd-xg(im),yd-yg(im)] & lmag = sqrt(total(lvec^2,/double))
;  ghat_dot_lvec = total(ghat*lvec, /double)
;  if (ghat_dot_lvec lt 0.) then begin
;    ghat = -1.d0*ghat
;    ghat_dot_lvec = total(ghat*lvec, /double)
;  endif
;  beta = acos(ghat_dot_lvec/lmag)
;  dperp = lmag*sin(beta)
;  dum = sqrt(lmag^2 - dperp^2)
;  if (bestord(im) eq 1) then oplot, [xd,dum*ghat(0)+xg(im)], $
;         [yd,dum*ghat(1)+yg(im)], $
;         line=0, color=cs.cyan, thick=3 
;  res = ''
;  read, res, prompt='Any key...'
    
endfor

; Spacecraft center and line along drift step
usersym, [-1,-1,1,1], [-1,1,1,-1], color=cs.black, /fill
oplot, [0], [0], psym=8, symsize=symsize
if (bestarg_ok) then oplot, [0.,5.*xd], [0.,5.*yd], line=0, color=cs.black, thick=thick_arrow

; Runner targets
runstr = ['Assignment not attempted: ', $
          'Assignment not possible:  ', $
          'Single    (order=1):      ', $
          'Double    (order=2):      ', $
          'Triple    (order=3):      ', $
          'Quadruple (order=4):      ', $
          'Quintuple (order=5):      ']

runstr = ['','','','','','','']

runnum = [-1,0,1,2,3,4,5]
runcol = [cs.black,cs.black,colors]

if (bestarg_ok) then begin
; Colored circles on the multi-runner targets
    for jjj=0,n_elements(colors)-1 do begin
        usersym, cos(findgen(10)*2.*!pi/9.), sin(findgen(10)*2.*!pi/9.), color=colors(jjj), /fill
        oplot, [(jjj+1)*xd], [(jjj+1)*yd], psym=8, color=colors(jjj), symsize=dot_symsize
    endfor
    
    arrow, xd,yd,0,0,/data,color=cs.red,/solid,thick=thick_arrow
endif

; Runner stats xyouts
outpos = norm_axis([.05,.90])
;xyouts, outpos(0),outpos(1), font+'BESTARG Runner Stats:'
for jjj=0,n_elements(runstr)-1 do begin
    
    runid = where(bestord eq runnum(jjj))
    if (runid(0) eq -1) then begin
        nrun = 0
        maxchstr = ''
    endif else begin
        nrun = n_elements(runid)
        maxchstr = '('
        for nmc=6,8 do begin
            mcid = where(mxch(runid) eq nmc)
            if (mcid(0) eq -1) then mcnum = 0 else mcnum = n_elements(mcid)
            maxchstr = maxchstr+string(mcnum,'(i3.3)')
            if (nmc ne 8) then maxchstr=maxchstr+','
        endfor
        maxchstr=maxchstr+')'
    endelse
    
    outstr = font+runstr(jjj)+string(nrun,'(i3.3)')+'  '+maxchstr
    outpos = norm_axis([.055,.90-(jjj+1)*.025])
;   xyouts, outpos(0), outpos(1), outstr, color=runcol(jjj)
    
endfor

;for im = 0, mb-1 do begin
;  xx=[xg(im),xtof(im)]
;  yy=[yg(im),ytof(im)]
;  oplot,xx,yy
;endfor

outs = norm_axis([.1,.9])
xyouts, outs(0), outs(1), plot_msg, color=cs.black

skip_the_rest:

return
end
