PRO JD2000,MJD2000,YEAR,MONTH,KDAY,HR,MI,SEC
;
;P  GIVES THE NEW MOD. JULIAN DAY (MJD2000=0.0 ON 2000/JAN/1 AT 0:00:00)
;P  FOR INPUT CALENDAR DATES BETWEEN 1950/JAN/1 AND 2099/DEC/31.
;
;   MJD2000 = MJD(1950) - 18262.0
;
;I YEAR    (INT)  = YEAR WITH 2 OR 4 DIGITS; 2 DIGITS => 1950 TO 2049
;I MONTH   (INT)  = MONTH
;I KDAY    (INT)  = DAY OF MONTH
;I HR      (INT)  = HOUR
;I MI      (INT)  = MINUTE
;I SEC     (DBL)  = SECOND.
;O MJD2000 (DBL)  = MOD. JUL. DAY, REFERRED TO 2000.
;
; History:
; ========
; 07-Dec-2000  Adapted from the FORTRAN program "jd2000.f"; (c) mfo@mpe.mpg.de
; 22-Jan-2001  Hiroshi Matsui pointed on a bug concerning INT-overflow -> LONG 
;=============================================================================

 JJ      = (14 - MONTH)/12
 L       = YEAR - JJ - 1900*(YEAR/1900) + 100*(2000/(YEAR+1951))
 MJD2000 = LONG(KDAY)-36496L+(1461L*L)/4+(367L*LONG(MONTH-2+JJ*12))/12L
 MJD2000 = DOUBLE(MJD2000) + (DOUBLE(LONG(HR*60 + MI)*60L) + SEC)/864.D2
RETURN
END
