FUNCTION  GETREF,  SYS


;C Find the index number of the transformation with code SYS. Used to
;C find terms in TSYS and DEFS.
;
;  !!!!!! return getref integer is IDL-index (0:nsys-1)

       common table,  nsys,defs,tsys,syscode

; fortran version (original)
;       getref = -1
;       for  j = 0,nsys-1  do begin
;            sy   = strupcase(strtrim(sys,2) )
;            syco = strupcase(strtrim(syscode(j),2) )
;            if (sy eq syco) then  getref = j
;       endfor

; IDL-version using where function
       sy   = strupcase(strtrim(sys,2) )
       syscode   = strupcase(strtrim(syscode,2) )
       get = where( syscode eq sy )
       if (get(0) eq -1) then stop        ; wrong syscode
       getref = get(0)                    ; array->int

       return, getref

END
