pro ep_write_pstat_data, id, ihour, pstat

common ep_envar_con_cb

printf, id, '==============================================='
printf, id, '==============================================='
printf, id, 'HOUR: '+strtrim(ihour,2)
printf, id, ''
printf, id, '# Analysis Intervals in this hour as'
printf, id, '  determined from the FGM spin-res file:  ',string(pstat.nspin_total(ihour),'(i5.5)')
printf, id, ''
printf, id, '# Analysis Intervals that fall w/i the'
printf, id, '  time range specified by the user:       ',string(pstat.nspin_user(ihour),'(i5.5)')
printf, id, ''

s = ['  # 1keV Intervals with enough ', $
     '  # .5keV Intervals with enough']

for index=0,1 do begin
    printf, id, '  --------------------------------'
    printf, id, s(index)
    printf, id, '    data (initially) for analysis:     ', string(pstat.nspin_edata(ihour,index),'(i5.5)')
    printf, id, '  --------------------------------'
    printf, id, '     # Successes:                   ', string(pstat.nspin_edata_succ(ihour,index),'(i5.5)')
    printf, id, '          # Good:           ', string(pstat.nspin_edata_succ_good(ihour,index),'(i5.5)')
    printf, id, '          # Caution:        ', string(pstat.nspin_edata_succ_caut(ihour,index),'(i5.5)')
    printf, id, '          # Bad:            ', string(pstat.nspin_edata_succ_bad(ihour,index),'(i5.5)')
    printf, id, '          # TRI:            ', string(pstat.nspin_edata_succ_tri(ihour,index),'(i5.5)')
    printf, id, '          # PMT:            ', string(pstat.nspin_edata_succ_pmt(ihour,index),'(i5.5)')
    printf, id, '          # SMT:            ', string(pstat.nspin_edata_succ_smt(ihour,index),'(i5.5)')
    printf, id, '          # RMT:            ', string(pstat.nspin_edata_succ_rmt(ihour,index),'(i5.5)')
    printf, id, '          # Beams Total:  ', string(pstat.nbeam_edata_succ(ihour,index),'(i7.7)')
    printf, id, '             # Class A: ', string(pstat.nbeam_edata_succ_classA(ihour,index),'(i7.7)')
    printf, id, '             # Class B: ', string(pstat.nbeam_edata_succ_classB(ihour,index),'(i7.7)')
    printf, id, '             # Class C: ', string(pstat.nbeam_edata_succ_classC(ihour,index),'(i7.7)')

    printf, id, '             # Class D: ', string(pstat.nbeam_edata_succ_classD(ihour,index),'(i7.7)')

    printf, id, '             # Class G: ', string(pstat.nbeam_edata_succ_classG(ihour,index),'(i7.7)')

    printf, id, '             # Class R: ', string(pstat.nbeam_edata_succ_classR(ihour,index),'(i7.7)')
    printf, id, '             # Outliers:', string(pstat.nbeam_edata_succ_trioutlier(ihour,index),'(i7.7)')
    printf, id, ''
    printf, id, '     # Failures:                    ', string(pstat.nspin_edata_fail(ihour,index),'(i5.5)')
    for i=0,n_elements(pstat.nspin_edata_fail_stats(ihour,index,*))-1 do begin
        if (pstat.nspin_edata_fail_stats(ihour,index,i) ne 0) then begin
            printf, id, '          '+pp_pstat(i)+ $
              '  :  ',string(pstat.nspin_edata_fail_stats(ihour,index,i),'(i5.5)')
        endif
    endfor
    printf, id, ''
endfor

return
end
