pro ep_write_cdf_data, cdf_unit, date, scnum, saveit, sbyte1, sbyte2, sbyte1_los, sbyte2_los

common ep_write_cdf_data_cb, recnum_acdf

if (n_elements(recnum_acdf) eq 0) then recnum_acdf = 0L

; Which indices should we use?
i = where(saveit(*).win_status eq 1) ; saveit has length 4 now
if (i(0) ne -1) then begin
    iwin = i(0)                 ; Could have two results, but take the lowest (1keV)
    case iwin of
        0:ilos=1
        1:ilos=0
        2:ilos=3
        3:ilos=2
    endcase
endif else return

; Write the winner to the CDF file
tail = '__C'+scnum+'_PPP_EDI'

epoch = ep_time_handler(saveit(iwin).time_ssm, 'ssm', 'epoch', date=date)
cdf_varput, cdf_unit, 'Epoch'+tail, epoch, rec_start=recnum_acdf

stat0 = byte(saveit(iwin).sbyte0)
stat1 = byte(sbyte1)
stat2 = byte(sbyte2)
stat3 = byte(saveit(iwin).sbyte3)
stat4 = byte(saveit(iwin).sbyte4)
stat5 = byte(saveit(iwin).sbyte5)
stat6 = byte(saveit(iwin).sbyte6)
cdf_varput, cdf_unit, 'Status'+tail, [stat0,stat1,stat2,stat3,stat4,stat5,stat6], $
  rec_start=recnum_acdf

cdf_varput, cdf_unit, 'V_ed_xyz_gse'+tail, saveit(iwin).v_out, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'E_xyz_gse'+tail, saveit(iwin).e_out, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Reduced_chi_sq'+tail, saveit(iwin).rchi2, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_mag'+tail, saveit(iwin).drift_step, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_mag_error_inertial'+tail, $
  saveit(iwin).d_error_inertial, rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_azi_error_inertial'+tail, $
  saveit(iwin).phi_error_inertial, rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Nbeam'+tail, saveit(iwin).nbeam_usd, $
  rec_start=recnum_acdf

; Write out loser result (Remember:  Loser could be
; successful result, but just not the winner)

stat0 = byte(saveit(ilos).sbyte0)
stat1 = byte(sbyte1_los)
stat2 = byte(sbyte2_los)
stat3 = byte(saveit(ilos).sbyte3)
stat4 = byte(saveit(ilos).sbyte4)
stat5 = byte(saveit(ilos).sbyte5)
stat6 = byte(saveit(ilos).sbyte6)
cdf_varput, cdf_unit, 'Status_loser'+tail, [stat0,stat1,stat2,stat3,stat4,stat5,stat6], $
  rec_start=recnum_acdf

cdf_varput, cdf_unit, 'V_ed_xyz_gse_loser'+tail, saveit(ilos).v_out, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'E_xyz_gse_loser'+tail, saveit(ilos).e_out, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Reduced_chi_sq_loser'+tail, saveit(ilos).rchi2, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_mag_loser'+tail, saveit(ilos).drift_step, $
  rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_mag_error_inertial_loser'+tail, $
  saveit(ilos).d_error_inertial, rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Drift_step_azi_error_inertial_loser'+tail, $
  saveit(ilos).phi_error_inertial, rec_start=recnum_acdf
cdf_varput, cdf_unit, 'Nbeam_loser'+tail, saveit(ilos).nbeam_usd, $
  rec_start=recnum_acdf

; Update record number for the archive CDF
recnum_acdf = recnum_acdf + 1L


return
end


