pro ep_reorder, xd, yd, beam

common ep_envar_con_cb

for im = 0, beam.mm-1 do begin
    
;===========================================================
; CLASS C, D, or G BEAMS
;===========================================================    
    if (beam.tri_ok(im) eq 1 and $
        (beam.class(im) eq 'C' or $
         beam.class(im) eq 'D' or $
         beam.class(im) eq 'G') and $
        beam.bestord(im) gt 1) then begin
        
; Firing direction unit vector
        ghat = [cos(beam.alpha(im)),sin(beam.alpha(im))]
        
        for iorder = beam.bestord(im)-1, 1, -1 do begin
            
; Unit vector from gun to iorder_th target
            that = [iorder*xd-beam.xg(im), iorder*yd-beam.yg(im)]
            tmag = sqrt(total(that^2))
            that = that/tmag
            
            angle = acos(total(ghat*that))
            
            if (angle gt pp_reorder_anglim_rad) then begin
                iorder_out = iorder + 1 ; Keep the order which is one up
                goto, order_out
            endif
            
            iorder_out = iorder
        endfor
        order_out:
        
        if (iorder_out ne beam.bestord(im)) then begin
            beam.bestord(im) = iorder_out
            beam.class(im) = 'R'
        endif
        
;===========================================================
; CLASS B BEAMS
;===========================================================
    endif else if (beam.tri_ok(im) eq 1 and $
                   beam.class(im) eq 'B'and $
                   beam.bestord(im) ne beam.posord(0,im)) then begin
        
; Firing direction unit vector
        ghat = [cos(beam.alpha(im)),sin(beam.alpha(im))]
        
; ibest will be greater than zero 'cause beam.bestord(im) ne
; beam.posord(0,i)
; NOTE:  Assumption below is that
; beam.posord(0:beam.n_posord(im)-1,im) is monotonically increasing,
; which it is as defined by ep_prep_order.pro
        ibest = where(beam.posord(0:beam.n_posord(im)-1,im) eq $
                      beam.bestord(im))
        
        if (ibest(0) le 0) then begin
            message, 'Problem with posord - No reordering done', /cont
            goto, next_beam
        endif
        
        for jorder = ibest(0)-1,0,-1 do begin
            
            iorder = beam.posord(jorder,im)
            
; Unit vector from gun to iorder_th target
            that = [iorder*xd-beam.xg(im), iorder*yd-beam.yg(im)]
            tmag = sqrt(total(that^2))
            that = that/tmag
            
            angle = acos(total(ghat*that))
            
            if (angle gt pp_reorder_anglim_rad) then begin
                iorder_out = beam.posord(jorder+1,im) ; Keep the order which is one up
                goto, order_out_b
            endif
            
            iorder_out = iorder
        endfor
        order_out_b:
        
        if (iorder_out ne beam.bestord(im)) then begin
            beam.bestord(im) = iorder_out
            beam.class(im) = 'R'
        endif

    endif

    next_beam:

endfor

return
end
