function ep_opmode_check, sn, checknum, mode_fields

mode_fields =[sn.hdr.science_mode, $
              sn.hdr.sub_mode, $
              sn.data_stream, $
              sn.hdr.pacmo, $
              255, $            ; Initialized here, possibly overwritten in ep_errorfree_check.pro
              255, $
              255, $
              255]

; Science mode 5 only
if (sn.hdr.science_mode NE 5) then begin
    checknum = 1
    return, 0
endif

; Sub-mode consistent with TM mode
submo_tmmo_ok = ep_submo_tmmo_check(sn)
if (not submo_tmmo_ok) then begin
    checknum = 2
    return, 0
endif
    
; No ram dumps 
if (sn.hdr.mem_dump_bit ne 0) then begin
    checknum = 3
    return, 0
endif

; NM1, PM1 not handled by PICK/EDI_PISO yet...
IF (sn.hdr.sub_mode EQ 1 AND sn.hdr.pacmo EQ 1) then begin
    checknum = 10
    return, 0
endif

return, 1
end
        


