# Commandline arguments
echo "EXTRACT COMMANDLINE INFO"
#     ========================
set date = $1      # 20010704
set scnum = $2     # 3
set IFFPATH = $3
set IFFNAME = $4
set QIFFPATH = $5
set CDFNAME = $6

echo " SET ENVIRONMENTS"
#      ================
#
setenv LD_LIBRARY_PATH $7
#
# The following environments need setting for your local environment
#
set CDFPATH = $IFFPATH
set CDFPROTO = $QIFFPATH
set SKTPATH = $QIFFPATH
set LOGPATH = $IFFPATH
#
set BIN = $QIFFPATH

# Copy this iffall to the standard name so that the software
# doesn't get confused
# C3_PP_EDI_20010704.IFF
cp -p ${IFFPATH}/${IFFNAME} ${IFFPATH}/C${scnum}_PP_EDI_${date}.IFF

#
# =============================================
# No editing below this line should be required
#
set CDFBIN = $8
#
#
echo " FILE TO BE GENERATED"
#      ====================
#
# C3_PP_EDI.skt
# C3_PP_EDI_20010704_V00.cdf
set file_head = C${scnum}_PP_EDI
set CDFFILE = ${file_head}_${date}
#
#
echo " GENERATE PROTOTYPE CDF FROM .SKT FILE"
#      ======================================
#
$CDFBIN/skeletoncdf -cdf $CDFPATH/$CDFFILE'_V00'  -fillval $SKTPATH/$file_head -report 'e' ;
#
#
#
echo " INGEST DATA FROM .iff-FILE INTO .cdf-FILE"
#      ==========================================
#
$BIN/Qiff -nodelete -log $LOGPATH  $IFFPATH $CDFPATH $CDFFILE;
#

# Move this CDF file to desired name
mv ${CDFPATH}/${CDFFILE}_V00.cdf ${CDFPATH}/${CDFNAME}.cdf

# Remove the dummy IFF file
rm ${IFFPATH}/C${scnum}_PP_EDI_${date}.IFF

exit        

