function ep_get_spinfgm, date, scnum, $
                         pp_edi_piso_fgm_out, pp_edi_piso_fgm_save, $
                         pp_gdc_rdda_root, $
                         pp_gdc_rdda_root2, $
                         pp_edi_piso_fgm_root, pp_edi_piso_att_orb_path, $
                         pp_edi_piso_bash, $
                         log_unit, iff_unit, $
                         pp_ep_code_path, $
                         msg_out, pp_spinfgm_file, ddata ; OUT
                         
pp_spinfgm_file = pp_edi_piso_fgm_out+'/fgmspin_'+scnum+'_' + $
  date+'.txt'

;-------------------------------------------------------------
; Create the SPIN file using Edita's script
if ((findfile(pp_spinfgm_file))(0) eq '') then begin
    printf, log_unit, 'Creating SPINRES FGM data file: '+ $
      pp_spinfgm_file
    printf, iff_unit, '%M '+ 'Creating SPINRES FGM data file: '+ $
      pp_spinfgm_file


;    str_diag = pp_edi_piso_bash+' -c "'+pp_ep_code_path+'/ep_spin_fgm.bash '+$
;      date+' '+$
;      scnum+' '+$
;      pp_gdc_rdda_root+' '+$
;      pp_spinfgm_file+' '+$
;      pp_edi_piso_att_orb_path+' '+$
;      pp_edi_piso_fgm_root+' '+$
;      pp_edi_piso_fgm_out+' '+$
;      pp_gdc_rdda_root2+'"'
;    print, str_diag
;    stop

    spawn, pp_edi_piso_bash+' -c "'+pp_ep_code_path+'/ep_spin_fgm.bash '+$
      date+' '+$
      scnum+' '+$
      pp_gdc_rdda_root+' '+$
      pp_spinfgm_file+' '+$
      pp_edi_piso_att_orb_path+' '+$
      pp_edi_piso_fgm_root+' '+$
      pp_edi_piso_fgm_out+' '+$
      pp_gdc_rdda_root2+'"', sout
    

    if ((findfile(pp_spinfgm_file))(0) eq '') then begin
        msg_out = 'SPINRES FGM data file creation not successful: '+ $
          pp_spinfgm_file
        return, 0
    endif else begin

        spawn, ['wc','-l',pp_spinfgm_file], flen, /noshell
        ipos = strpos(flen(0),pp_spinfgm_file)
        if (ipos eq -1) then nrl = LONG(flen[0]) else $
          nrl = long(strmid(flen(0),0,ipos-1))

        if (nrl le 5) then begin
            msg_out = 'SPINRES FGM data file created is corrupted: '+ $
              pp_spinfgm_file
            return, 0
        endif
    endelse
endif else begin
    printf, log_unit, 'Using existing SPINRES FGM data file: '+ $
      pp_spinfgm_file
    printf, iff_unit, '%M '+'Using existing SPINRES FGM data file: '+ $
      pp_spinfgm_file

    spawn, ['wc','-l',pp_spinfgm_file], flen, /noshell
    ipos = strpos(flen(0),pp_spinfgm_file)
    if (ipos eq -1) then nrl = LONG(flen[0]) else $
      nrl = long(strmid(flen(0),0,ipos-1))
    
    if (nrl le 5) then begin
        msg_out = 'Existing SPINRES FGM data file is corrupted: '+ $
          pp_spinfgm_file
        return, 0
    endif
endelse

;-------------------------------------------------------------
; Read the file
; Spin-averaged Magnetic Field, by courtesy of Edita Georgescu:
;      should contain 6 columns : time (sec since 1970), Bx, By, Bz
;      (in nT), variance1, variance2
;      where "time" contains 9 decimals after "." = fraction of sec (nanosec).
; 2-line tail of calibration file info.  De-spun, spacecraft
; coordinate system (SCS)...X_SCS is in the spin plane, pointing
; towards the sun (as determined by the sun-pulse)...Z_SCS is along
; the spin axis.

spawn, ['wc','-l',pp_spinfgm_file], flen, /noshell
ipos = strpos(flen(0),pp_spinfgm_file)
if (ipos eq -1) then nrl = LONG(flen[0]-2) else $
  nrl = long(strmid(flen(0),0,ipos-1))-2

ddata=DBLARR(6,nrl)
openr,lun_mag,pp_spinfgm_file,/get_lun
readf,lun_mag,ddata
str1 = '' & str2 = ''
readf,lun_mag,str1
readf,lun_mag,str2
free_lun,lun_mag

printf, log_unit, 'Number of spin-averaged FGM vectors: '+strtrim(nrl,2)
printf, log_unit, 'FGM B-field file format            : '+str1
printf, log_unit, 'FGM B-field calibration info       : '+str2
printf, iff_unit,'G Inst_settings "fgm_cal>'+strtrim(str2,2)+'"'

; Delete the file if desired
if (not pp_edi_piso_fgm_save) then spawn, 'rm '+pp_spinfgm_file, sout

return, 1
end
