function ep_get_hrfgm_oh, date_in, scnum, ihour_in, $
                          t70_midnight0, t70_midnight1, $
                          pp_edi_piso_fgm_out, pp_edi_piso_fgm_save, $
                          pp_gdc_rdda_root, $
                          pp_gdc_rdda_root2, $
                          pp_edi_piso_fgm_root, pp_edi_piso_att_orb_path, $
                          pp_edi_piso_bash, $
                          log_unit, iff_unit, $
                          pp_ep_code_path, $
                          msg_out, pp_hrfgm_file, hrbt_ssm, hrbv_scs ; OUT

t70_midnight = double(t70_midnight0) + $
  double(t70_midnight1)/1d6     ; decimal t70 (seconds since 01-Jan-1970)

if (ihour_in ne 0 and ihour_in ne 23) then begin
    ih1_adjusted = string(ihour_in-1,'(i2.2)')
    ih2_adjusted = string(ihour_in+1,'(i2.2)')
    h1s = ['T'+ih1_adjusted+':59:00.000Z'] ; 1 minute buffers
    h2s = ['T'+ih2_adjusted+':01:00.000Z']
    dates = [date_in]
    tstr1s = [ih1_adjusted+'5900']
    tstr2s = [ih2_adjusted+'0100']
endif else if (ihour_in eq 0) then begin
; Find date for previous day
    t70_2350 = t70_midnight - 10.*60. ; 10 min. into previous day
    vstr = ep_time_handler(t70_2350,'t70','vax_string')
    date_prev = date2datevax(strmid(vstr,0,11),/reverse)
    dates = [date_prev,date_in]
    h1s = ['T23:59:00.000Z','T00:00:00.000Z']
    h2s = ['T23:59:59.999Z','T01:01:00.000Z']
    tstr1s = ['235900','000000']
    tstr2s = ['235959','010100']
endif else if (ihour_in eq 23) then begin
; Find date for next day
    t70_0010 = t70_midnight + 24.*3600. + 10.*60. ; 10 min. into next day
    vstr = ep_time_handler(t70_0010,'t70','vax_string')
    date_next = date2datevax(strmid(vstr,0,11),/reverse)
    dates = [date_in,date_next]
    h1s = ['T22:59:00.000Z','T00:00:00.000Z']
    h2s = ['T23:59:59.999Z','T00:01:00.000Z']
    tstr1s = ['225900','000000']
    tstr2s = ['235959','000100']
endif

pp_hrfgm_file = strarr(n_elements(dates))
hrbt_ssm = 1.
hrbv_scs = fltarr(3,1)
file_not_found = ''

; Loop needed here for the ihour_in=0 and ihour_in=23 cases where the
; neighboring days are required to buffer the data by 1 minute on
; either side...This is a requirement of Hans' RunEst.pro program that
; the magnetic field data fully encompass the edi data.
for idate = 0, n_elements(dates)-1 do begin
    
    date = dates(idate)
    h1 = h1s(idate)
    h2 = h2s(idate)
    tstr1 = tstr1s(idate)
    tstr2 = tstr2s(idate)
    
; Full filename of HR FGM file for this piece
    pp_hrfgm_file(idate) = pp_edi_piso_fgm_out+'/fgmhr_'+ $
      scnum+'_'+date+'_'+tstr1+'_'+tstr2+'.txt'
    
; Create the HR file using Edita's script
    if ((findfile(pp_hrfgm_file(idate)))(0) eq '') then begin
        printf, log_unit, 'Creating HIGHRES FGM data file: '+ $
          pp_hrfgm_file(idate)
        printf, iff_unit, '%M '+ 'Creating HIGHRES FGM data file: '+ $
          pp_hrfgm_file(idate)

;===Diag===
;        str_diag = pp_edi_piso_bash+' -c "'+pp_ep_code_path+'/ep_high_fgm.bash '+date+' '+scnum+' '+h1+' '+h2+' '+pp_gdc_rdda_root+' '+pp_edi_piso_fgm_root+' '+pp_edi_piso_att_orb_path+' '+pp_hrfgm_file(idate)+' '+pp_edi_piso_fgm_out+' '+pp_gdc_rdda_root2+'"'
;        print, str_diag
;        stop
;==========

        
        spawn, pp_edi_piso_bash+' -c "'+pp_ep_code_path+'/ep_high_fgm.bash '+date+' '+scnum+' '+h1+' '+h2+' '+pp_gdc_rdda_root+' '+pp_edi_piso_fgm_root+' '+pp_edi_piso_att_orb_path+' '+pp_hrfgm_file(idate)+' '+pp_edi_piso_fgm_out+' '+pp_gdc_rdda_root2+'"', sout


;===Diag===
;print, sout
;stop
;==========        
        if ((findfile(pp_hrfgm_file(idate)))(0) eq '') then begin

            if (idate ne n_elements(dates)-1) then begin
                file_not_found = file_not_found + ':'+pp_hrfgm_file(idate)
                goto, next_date
            endif else begin
                if (n_elements(hrbt_ssm) eq 1) then begin ; No data has been collected
                    msg_out = 'HIGHRES FGM data file creation not successful: '+ $
                      file_not_found+':'+pp_hrfgm_file(idate)
                    return, 0
                endif else begin ; Data has been collected already; ready to crop
                    goto, crop_data
                endelse
            endelse
            
        endif else begin
            
            spawn, ['wc','-l',pp_hrfgm_file(idate)], flen, /noshell
            ipos = strpos(flen(0),pp_hrfgm_file(idate))
            if (ipos eq -1) then nrl = LONG(flen[0]) else $
              nrl = long(strmid(flen(0),0,ipos-1))
            
            if (nrl le 5) then begin
                
                if (idate ne n_elements(dates)-1) then begin
                    file_not_found = file_not_found + ':'+pp_hrfgm_file(idate)
                    goto, next_date
                endif else begin
                    if (n_elements(hrbt_ssm) eq 1) then begin ; No data has been collected
                        msg_out = 'HIGHRES FGM data file creation not successful: '+ $
                          file_not_found+':'+pp_hrfgm_file(idate)
                        return, 0
                    endif else begin ; Data has been collected already; ready to crop
                        goto, crop_data
                    endelse
                endelse
;old                msg_out = 'HIGHRES FGM data file created just now is corrupted: '+ $
;old                  pp_hrfgm_file(idate)
;old                return, 0
            endif

        endelse
    endif else begin
        printf, log_unit, 'Using existing HIGHRES FGM data file: '+ $
          pp_hrfgm_file(idate)
        printf, iff_unit, '%M '+ 'Using existing HIGHRES FGM data file: '+ $
          pp_hrfgm_file(idate)

        spawn, ['wc','-l',pp_hrfgm_file(idate)], flen, /noshell
        ipos = strpos(flen(0),pp_hrfgm_file(idate))
        if (ipos eq -1) then nrl = LONG(flen[0]) else $
          nrl = long(strmid(flen(0),0,ipos-1))

        if (nrl le 5) then begin

            if (idate ne n_elements(dates)-1) then begin
                file_not_found = file_not_found + ':'+pp_hrfgm_file(idate)
                goto, next_date
            endif else begin
                if (n_elements(hrbt_ssm) eq 1) then begin ; No data has been collected
                    msg_out = 'HIGHRES FGM data file creation not successful: '+ $
                      file_not_found+':'+pp_hrfgm_file(idate)
                    return, 0
                endif else begin ; Data has been collected already; ready to crop
                    goto, crop_data
                endelse
            endelse
;old            msg_out = 'Existing HIGHRES FGM data file is corrupted: '+ $
;old              pp_hrfgm_file(idate)
;old            return, 0
        endif
    endelse
    
; Read the file
    spawn, ['wc','-l',pp_hrfgm_file(idate)], flen, /noshell
    ipos = strpos(flen(0),pp_hrfgm_file(idate))
    if (ipos eq -1) then nrl = LONG(flen[0]) else $
      nrl = long(strmid(flen(0),0,ipos-1))
    
    ddata=DBLARR(4,nrl)
    openr,lun_mag,pp_hrfgm_file(idate),/get_lun
    readf,lun_mag,ddata
    free_lun,lun_mag
    
; Grab the time (which is a double)
    t70 = reform(ddata(0,*))
; Construct the time tag for the field data in seconds since midnight, ssm
    dum = transpose( [ [long(t70)],[long( (t70 - long(t70))*1d6 )] ] )
    dum = sub_ctime( dum, [t70_midnight0,t70_midnight1] )
    hrbt_ssm0 = reform(double(dum(0,*)) + double(dum(1,*))/1d6) ; ssm
    t70 = 0
    
; Now define the field, 'h'igh 'r'es 'b'field 'v'ector
    hrbv_scs0 = float(ddata(1:3,*))
    
; De-allocate some space
    ddata = 0

; Augment the output arrays
    nnew = n_elements(hrbt_ssm0)
    nold = n_elements(hrbt_ssm)
    
    hrbt_ssm = [hrbt_ssm,hrbt_ssm0]
    bsave = hrbv_scs
    hrbv_scs = fltarr(3,nold+nnew)
    hrbv_scs(0:2,0:nold-1) = bsave
    hrbv_scs(0:2,nold:nold+nnew-1) = hrbv_scs0

; De-allocate some space
    hrbt_ssm0 = 0
    hrbv_scs0 = 0
    
    if (not pp_edi_piso_fgm_save) then spawn, 'rm '+pp_hrfgm_file(idate)


    next_date:

endfor

crop_data:
ntime = n_elements(hrbt_ssm)
hrbt_ssm = hrbt_ssm(1:ntime-1)
hrbv_scs = hrbv_scs(0:2,1:ntime-1)

return, 1
end
