#-------------------------------------------------------
# Source the paths for this machine
source ${EP_CODE_PATH}/ep_${EDI_PISO_MACHINE}_paths.csh

# For the time-being, overwrite some of those paths defined in
# ep_MACHINE_paths.csh with those defined by the edi_sprod
# scripts
setenv EDI_PISO_PICK_PATH $EDI_SPROD_TEMPCODE_PATH
setenv GDC_OUT_DIR $EDI_SPROD_OUT_PATH
setenv EDI_PISO_AUX_OUT $EDI_SPROD_OUT_PATH
setenv EDI_PISO_LOG_OUT $EDI_SPROD_OUT_PATH
setenv EDI_PISO_PSTAT_OUT $EDI_SPROD_OUT_PATH
setenv EDI_PISO_FGM_OUT $EDI_SPROD_TEMPDATA_PATH
setenv EP_TEMPDATA_PATH $EDI_SPROD_TEMPDATA_PATH
setenv EDI_PISO_CDF_OUT $EDI_SPROD_OUT_PATH

#-------------------------------------------------------
# Must choose which difference map to use.
setenv EDI_PISO_DM DM03

#-------------------------------------------------------
# Set to write to the IFFALL file every hour instead of every spin (default)
setenv EDI_PISO_IFF_HOURLY 0

#-------------------------------------------------------
# Must set whether or not you want to save the FGM files
setenv EDI_PISO_FGM_SAVE 0

#-------------------------------------------------------
# Diagnostics keywords (run-time plots, for PPQ)
setenv EDI_PISO_KEYPLOT3 0
setenv EDI_PISO_KEYPLOT4 0

#-------------------------------------------------------
# IFF file name - If set, the IFF filename will have the
# same form as the AUX and LOG filenames.
setenv EDI_PISO_LONG_IFFNAME 1

#-------------------------------------------------------
# PP-Plus file name - If set, the PP-Plus filename will have the
# same form as the AUX, PSTAT and LOG filenames. Otherwise it
# has the standardized name used by the GCDC
setenv EDI_PISO_LONG_PPPLUSNAME 1

#-------------------------------------------------------
# Set various EDI_PISO control parameters.
# First load all of the defaults.  If you want to change
# any of them, just do so where indicated below.
# All of the control parameters are documented in:
#             ${EDI_PISO_DM}_DEF.txt
source ${EDI_SPROD_TEMPCODE_PATH}/edi_piso_pp_defaults.csh

#---------------------------------------------------------
# Get the 'state' information from the file containing the
# form data generated by running edi_sprod.pro
#---------------------------------------------------------

set def_file = ${EDI_SPROD_STATE}/${EDI_SPROD_STATE}.state

#-----------------------------
# Check for def_file existence
#-----------------------------
setenv SPROD_OK 1
set f = `ls -1 ${def_file}`
if ("${#f}" == "0") then
    echo "edi_sprod state file not found: ${def_file}"
    echo "Aborting"
    setenv SPROD_OK 0
    exit
endif

#-------------------------------------------------------
#--write_aux--
# Must set whether or not you want to write the aux file
#-------------------------------------------------------
setenv EDI_PISO_WRITE_AUX 0
set waux = `cat ${def_file} | grep 'sprod_write_aux'`
set nlen = `echo $waux | wc -c`
@ nlen--
set waux = `echo $waux | cut -c17-$nlen`
if ("$waux" == "1") setenv EDI_PISO_WRITE_AUX 1

#---------------------------------------------------------------
#--write_arcdf--
# Must set whether or not you want to write the archive CDF file
#---------------------------------------------------------------
setenv EDI_PISO_WRITE_CDF 0
set warcdf = `cat ${def_file} | grep 'sprod_write_arcdf'`
set nlen = `echo $warcdf | wc -c`
@ nlen--
set warcdf = `echo $warcdf | cut -c19-$nlen`
if ("$warcdf" == "1") setenv EDI_PISO_WRITE_CDF 1

#echo 'TEST!'
#setenv
#exit

#-----------------
#--filename_root--
#-----------------
set filename_root = `cat ${def_file} | grep 'sprod_filename_root'`
set nlen = `echo $filename_root | wc -c`
@ nlen--
set filename_root = `echo $filename_root | cut -c21-$nlen`

#---------
#--tinfo--
#---------
set tinfo = `cat ${def_file} | grep 'sprod_tinfo'`
set nlen = `echo $tinfo | wc -c`
@ nlen--
set tinfo = `echo $tinfo | cut -c13-$nlen`

#---------
#--finfo--
#---------
set finfo = `cat ${def_file} | grep 'sprod_finfo'`
set nlen = `echo $finfo | wc -c`
@ nlen--
set finfo = `echo $finfo | cut -c13-$nlen`

#--------
#--nvar--
#--------
set nvar = `cat ${def_file} | grep 'sprod_pp_nvar'`
set nlen = `echo $nvar | wc -c`
@ nlen--
set nvar = `echo $nvar | cut -c15-$nlen`

if ("$nvar" == "0") then
    echo "Not updating any control parameters"
else
    echo "Updating ${nvar} control parameters"

    set varnames = `cat ${def_file} | grep 'sprod_pp_varnames'`
    set nlen = `echo $varnames | wc -c`
    @ nlen--
    set varnames = `echo $varnames | cut -c19-$nlen`

    set varvalues = `cat ${def_file} | grep 'sprod_pp_varvalues'`
    set nlen = `echo $varvalues | wc -c`
    @ nlen--
    set varvalues = `echo $varvalues | cut -c20-$nlen`    

    @ j = 0
    foreach i ($varnames)
    
	@ j++
	
# Update control parameter
	setenv $varnames[${j}] $varvalues[${j}]
        echo $varnames[${j}] $varvalues[${j}]
    
    end
endif

#echo "finfo: ${finfo}"
#echo "tinfo: ${tinfo}"
#setenv

exit
