#-------------------------------------------------------
# Source the paths for this machine
source ${EP_CODE_PATH}/ep_${EDI_PISO_MACHINE}_paths.csh

#-------------------------------------------------------
# Set difference map (don't change).
setenv EDI_PISO_DM DM03

#-------------------------------------------------------
# Set to write to the IFFALL file every hour instead of every spin (default)
setenv EDI_PISO_IFF_HOURLY 0

#-------------------------------------------------------
# Must set whether or not you want to save the FGM files
setenv EDI_PISO_FGM_SAVE 1

#-------------------------------------------------------
# Diagnostics keywords (run-time plots, for PPQ)
setenv EDI_PISO_KEYPLOT3 0
setenv EDI_PISO_KEYPLOT4 0

#-------------------------------------------------------
# Must set whether or not you want to write the aux file
setenv EDI_PISO_WRITE_AUX 0

#-------------------------------------------------------
# Must set whether or not you want to write the archive CDF file
setenv EDI_PISO_WRITE_CDF 1

#-------------------------------------------------------
# IFF file name - If set, the IFF filename will have the
# same form as the AUX, PSTAT and LOG filenames.
setenv EDI_PISO_LONG_IFFNAME 0

#-------------------------------------------------------
# PP-Plus file name - If set, the PP-Plus filename will have the
# same form as the AUX, PSTAT and LOG filenames. Otherwise it
# has the standardized name used by the GCDC
setenv EDI_PISO_LONG_PPPLUSNAME 0

#-------------------------------------------------------
# Set various EDI_PISO control parameters.
# First load all of the defaults.  If you want to change
# any of them, just do so where indicated below.
# All of the control parameters are documented in:
#             ${EDI_PISO_DM}_DEF.txt
source ${EP_CODE_PATH}/edi_piso_pp_defaults.csh

#-------------------------------------------------------
# Change any of the environment variables here:
# e.g. :
#        setenv pp_nchunk 2

#-------------------------------------------------------
# Setting the 'finfo' (file information) and 
# 'tinfo' (time information) variable arrays:
#
# 3 POSSIBLE finfo FORMS:
#    cl2_2000-10-05t15_54_00z.nsd
#    cl2_2000-10-05t15_54_00z.bsd
#    cl2_2000-10-05t00_00_00z.msf
#
# NOTE: For the 'nsd' and 'bsd' types, finfo
#       specifies the exact file to be used.  For the 'msf'
#       type, the '00_00_00' is just a place holder and is
#       not used for anything.
#
#       For either case, you must additionally specify
#       'tinfo' (start and end time string, see below)
#       It has the form HH_MM_SS-HH_MM_SS. It must be set for
#       every file listed in the 'finfo' variable.
#
#       If you want to use all of the data in the file, 
#       (for example if you don't know the time range
#       available within the file) just set tinfo to ALL.
#-------------------------------------------------------

set tinfo = (ALL)

set year = `echo ${EDI_PISO_PRODUCTION_DATE} | cut -c1-4`
set month = `echo ${EDI_PISO_PRODUCTION_DATE} | cut -c5-6`
set day = `echo ${EDI_PISO_PRODUCTION_DATE} | cut -c7-8`
set finfo = (cl${EDI_PISO_SC_NUMBER}_${year}-${month}-${day}t00_00_00z.msf)


exit
