function ep_bit7sob_eswitch_check, sn

; Check to see if energy switching is consistent with
; having set the 7th bit of sob.  If this is not the case,
; skip this packet because we don't know yet why the energy
; index is changing (it shouldn't if the 7th bit of sob is not set).

; NOTE: sn.shdr.m5.sob is for SCIENCE mode 5, not PACKING mode 5
;       This check doesn't make sense for any other science mode

pacmo_str = string(sn.hdr.pacmo,'(i1)')
estat = execute('pdata=sn.pacmo'+pacmo_str) ; Packet data

; New, 20021106
n_subp = pdata.data_count
vx1 = pdata.data(0:n_subp-1).vax1
vy1 = pdata.data(0:n_subp-1).vay1
vx2 = pdata.data(0:n_subp-1).vax2
vy2 = pdata.data(0:n_subp-1).vay2

gd = where( (vx1 ne 0 and vy1 ne 0) or $ ; Non-fill records
            (vx2 ne 0 and vy2 ne 0) )

if (gd(0) ne -1) then begin
    
    eindex = pdata.data(0:n_subp-1).e
    if ( (min(eindex(gd)) ne max(eindex(gd))) and $
         ( not (sn.shdr.m5.sob and 2^(7-1))/2^(7-1) ) ) then return, 0
    
endif

return, 1
end
