pro ep_bestarg_grids_orig, reso, yestof, nmchip, rmax_in, vb, $ ; IN
                           rd, pd, tg, dtg, $ ; IN for fine/coarse grid
                           irbest, ipbest, itbest, ibest2,$ ; IN for fine grid
                           nr, np, nt, rarr, parr, tarr, $ ; IN and OUT
                           acfir, acrad, acgdu, actof, $ ; OUT
                           sigfir, siggdu, sigtof, $ ; IN and OUT
                           resop, resot, $ ; OUT
                           siz, $ ; OUT
                           coarse=coarse, fine=fine

acfir= 1.*!pi/180		; error of the beam firing direction
acrad= 0.03			; typical relative error in driftstep
acgdu= 0.05			; error of beam source and sink in meters
actof= nmchip*2.^(-23)/8.*1e6	; error on ToF in microseconds

if (not keyword_set(fine)) then begin
;===========================================================
;====================COARSE GRID============================
;===========================================================

    sigfir= acfir 
    siggdu= acgdu 
    sigtof= actof 

; ====================== Radial ============================
    if yestof then resor = 10.*acrad *reso else resor = 3.*acrad *reso
                                ;driftstep resolution (for large steps)
    rb = acgdu/resor
    ib = 1./resor
    rmin = 0.
    rmax = rmax_in * (1+resor)
    rr = 0.
    ir = -1
    il = -1
    while rr le rmax do begin
        siz = rr/1.41421        ;size of plot window
        if rr le rmin then il = il + 1
        ir = ir + 1             ;this function defines spacing in driftstep
        rr= rb*((0.0579/ib)+(ir/ib)*(ir le ib)+(1+1/ib)^(ir-ib)*(ir gt ib))
    endwhile
    iu = ir - 1
    nr = long(iu - il + 1)

; ===================== Phi ================================
    resop = 3.*acfir *reso      ;azimuthal resolution in radians
    np = 4*fix(!pi/2/resop)
    resop = 2*!pi / np
    pmin = -!pi
    pmax =  !pi
    pmin = (fix(pmin/resop) +0.5) * resop
    pmax = (fix(pmax/resop) -0.5) * resop
    np = long((pmax-pmin) / resop + 1.5)

; ===================== Tgyro ==============================
    resot = 10.*actof *reso     ;gyrotime resolution in microseconds
    if yestof then begin
        tmin = tg - dtg
        tmax = tg + dtg
        resot = resot <(1.01*dtg)
        nt = 2 * long(dtg/resot +1) + 1
    endif else begin
        nt = 1l
    endelse
    
;******************************************************************
    rarr= findgen(nr*np) mod nr + il
    rarr= rb*((0.0579/ib)+(rarr/ib)*(rarr le ib) + $
              (1+1/ib)^(rarr-ib)*(rarr gt ib))
    rarr= reform(rarr#transpose(fltarr(nt)+1.),nr,np,nt) ;driftstep samples
    
    parr= resop * (findgen(nr*np) mod np) + pmin
    parr= reform(rotate(reform(parr,np,nr),1),nr*np)	
    parr= reform(parr#transpose(fltarr(nt)+1.),nr,np,nt) ;azimuth samples
    
    tarr= reform((fltarr(nr*np)+1.) # $
                 transpose(findgen(nt)-0.5*(nt-1)),nr,np,nt)
    tarr= tg + tarr * resot     ;gyrotime samples

endif else begin
;=========================================================
;====================FINE GRID============================
;=========================================================
    
;=================== Radial ===========================
    irmin =  irbest-fix(3/reso)
    irmax = (irbest+fix(3/reso)) < (nr-1)
    rmax = rarr(irmax,0,0)
    siz = rmax                  ;size of plot window    
    resor = acrad *reso         ;driftstep resolution (for large steps)
    rb = acgdu/resor
    ib = 1./resor
    if irmin ge 0 then rmin = rarr(irmin,0,0) else rmin = 0.
    rr = 0.
    ir = -1
    il = -1
    while rr le rmax do begin
        if rr le rmin then il = il + 1
        ir = ir + 1             ;this function defines spacing in driftstep
        rr= rb*((0.0579/ib)+(ir/ib)*(ir le ib)+(1+1/ib)^(ir-ib)*(ir gt ib))
    endwhile
    iu = ir - 1
    nr = long(iu - il + 1)

;==================== Phi =============================
    ipmin = (ipbest-fix(2/reso) +np) mod np
    ipmax = (ipbest+fix(2/reso)) mod np
    pmin = parr(0,ipmin,0)
    pmax = parr(0,ipmax,0)
    if pmin gt pmax then pmax = pmax + 2*!pi
    resop = acfir *reso         ;azimuthal resolution in radians
    np = 4*fix(!pi/2/resop)
    resop = 2*!pi / np
    pmin = (fix(pmin/resop) +0.5) * resop
    pmax = (fix(pmax/resop) -0.5) * resop
    np = long((pmax-pmin) / resop + 1.5)

;================== Tgyro ==============================
    resot = (actof >(acrad*rd/vb)) *reso ;gyrotime resolution in microseconds
    if yestof then begin
        itmin = (itbest-fix(1/reso)) > 0
        itmax = (itbest+fix(1/reso)) < (nt-1)
        tmin = tarr(0,0,itmin)
        tmax = tarr(0,0,itmax)
        dtg = (tmax-tmin) / 2.
        tg = (tmax+tmin) / 2.
        resot = resot <(1.1*dtg)
        nt = 2 * long(dtg/resot +1) + 1
    endif else begin
        nt = 1l
    endelse
    
;******************************************************************
;Often, the likelihood function has several minima. Therefore makes sense to
;check where the second-best target (ibest2) is located. If this second-best
;target is too far away from the best target (ibest) then the solution is
;rejected and BESTARG returns with yestof<0. I disabled this criterion after I
;found that I did not need it to eliminate unwanted solutions. Maybe it is
;useful in the future. Then it should also be looked at the difference,
;fgb2-fgb, between the likelihood functions at ibest and ibest2. In any case,
;this criterion depends on reso, since for sufficiently high resolution ibest2
;is always close to ibest.
;******************************************************************
;if rarr(ibest2) lt rmin or rarr(ibest2) gt rmax then begin
;	yestof = -2
;	return
;endif
;dpglobal= abs(parr(ibest2) - pd)
;dpglobal= dpglobal*(dpglobal lt !pi)+(2*!pi-dpglobal)*(dpglobal ge !pi)
;if dpglobal gt (pmax-pmin)/2 then begin
;	yestof = -3
;	return
;endif
;if yestof then begin
;  if tarr(ibest2) lt tmin or tarr(ibest2) gt tmax then begin
;	yestof = -4
;	return
;  endif
;endif

;******************************************************************
    rarr= findgen(nr*np) mod nr + il
    rarr= rb*((0.0579/ib)+(rarr/ib)*(rarr le ib) + $
              (1+1/ib)^(rarr-ib)*(rarr gt ib))
    rarr= reform(rarr#transpose(fltarr(nt)+1.),nr,np,nt) ;driftstep samples
    
    parr= resop * (findgen(nr*np) mod np) + pmin
    parr= reform(rotate(reform(parr,np,nr),1),nr*np)	
    parr= reform(parr#transpose(fltarr(nt)+1.),nr,np,nt) ;azimuth samples
    
    tarr= reform((fltarr(nr*np)+1.) # $
                 transpose(findgen(nt)-0.5*(nt-1)),nr,np,nt)
    tarr= tg + tarr * resot     ;gyrotime samples
endelse

return
end
