pro ep_augment_oh_data, sn, checknum, mode_fields, init=init, crop=crop

common edi_piso_onehour_common, btime1,btime2,atime0,atime1,t1,t1m2,VAX1,VAY1,VAX2,VAY2,I1,I2,SQ1,SQ2,E_INDEX,NNN,mm,code_type,sob,limhi,limlo,cnum,inmodstr,mxch1,mxch2

common ep_envar_con_cb

if keyword_set(crop) then begin
; Crop off the first element of each array
    ndata = n_elements(atime0)

    btime1    = btime1(1:ndata-1)
    btime2    = btime2(1:ndata-1)
    atime0    = atime0(1:ndata-1)
    atime1    = atime1(1:ndata-1)
    t1        = t1(1:ndata-1)
    t1m2      = t1m2(1:ndata-1)
    VAX1      = VAX1(1:ndata-1)
    VAY1      = VAY1(1:ndata-1)
    VAX2      = VAX2(1:ndata-1)
    VAY2      = VAY2(1:ndata-1)
    mxch1     = mxch1(1:ndata-1)
    mxch2     = mxch2(1:ndata-1)
    I1        = I1(1:ndata-1)
    I2        = I2(1:ndata-1)
    SQ1       = SQ1(1:ndata-1)
    SQ2       = SQ2(1:ndata-1)
    E_INDEX   = E_INDEX(1:ndata-1)
    NNN       = NNN(1:ndata-1)
    mm        = mm(1:ndata-1)
    code_type = code_type(1:ndata-1)
    sob       = sob(1:ndata-1)
    limhi     = limhi(1:ndata-1)
    limlo     = limlo(1:ndata-1)
    cnum = cnum(1:ndata-1)
    inmodstr = inmodstr(1:ndata-1)
    
    return
endif



if (keyword_set(init)) then begin
; Initialize the variables that will be augmented subpacket by
; subpacket and then will have the first element cropped off.
    sob          = 0b
    limhi        = 0b
    limlo        = 0b
    btime1       = 0.d0
    btime2       = 0.d0
    atime0       = 0L           ; actual time (sec since 1970)
    atime1       = 0L           ;   "      "  (microsec)
    t1           = 0L           ; /* Time of Flight for det 1 */
    t1m2         = 0            ; /* ToF for det 1 - ToF for det 2 */
    VAX1         = 0            ; voltage, X-component, gun 1
    VAY1         = 0            ;    "     Y    "          "
    VAX2         = 0            ;    "     X    "       gun 2
    VAY2         = 0            ;    "     Y    "          "
    I1           = 0b           ; /* index for detector 1 */
    I2           = 0b           ; /* index for detector 2 */
    SQ1          = 0b           ; /* quality bits for detector 1 */
    SQ2          = 0b           ; /* quality bits for detector 2 */
    E_INDEX      = 0b           ; /* energy bit: 0=>1 KeV, 1=>500 eV)
    NNN          = 0b           ; /* correlator parameter */
                                ; Confirmed 13.12.2000:  NNN has
                                ; possible values [1,2,4,8,16,32,64]
                                ; and is NOT the original 3-bit number
                                ; but has already been mapped to the
                                ; the numbers above, i.e.
                                ; 3-bit:  [0,  1,  2,  3,  4,  5,  6,  7]
                                ; NNN:    [1,  2,  4,  8,  8, 16, 32, 64]
    
    mm           = 0b
    code_type    = 0b
    cnum = 0b
    inmodstr = 'EDI_??_??_??_??_??_??_??_??'
    mxch1        = 0b
    mxch2        = 0b

    return
endif

if (checknum ne 0) then begin

    cnum = [cnum,checknum]
    inmodstr = [inmodstr, 'EDI_' + $
                string(mode_fields(0),'(z2.2)')+'_'+ $
                string(mode_fields(1),'(z2.2)')+'_'+ $
                string(mode_fields(2),'(z2.2)')+'_'+ $
                string(mode_fields(3),'(z2.2)')+'_'+ $
                string(mode_fields(4),'(z2.2)')+'_'+ $
                string(mode_fields(5),'(z2.2)')+'_'+ $
                string(mode_fields(6),'(z2.2)')+'_'+ $
                string(mode_fields(7),'(z2.2)')]
    
    btime1    = [btime1,pp_rfill]
    btime2    = [btime2,pp_rfill]
    
    
; The atimes are used to determine which spin interval-- no fill!
; I am going to use the packet time because atimes for these cases
; aren't defined.
    atime0    = [atime0,sn.hdr.packet_time(0)]
    atime1    = [atime1,sn.hdr.packet_time(1)]
    
    t1        = [t1,pp_i4fill]
    t1m2      = [t1m2,pp_i2fill]
    VAX1      = [vax1,pp_i2fill]
    VAY1      = [vay1,pp_i2fill]
    VAX2      = [vax2,pp_i2fill]
    VAY2      = [vay2,pp_i2fill]
    I1        = [i1,pp_bfill]
    I2        = [i2,pp_bfill]
    mxch1     = [mxch1,pp_bfill]
    mxch2     = [mxch2,pp_bfill]
    SQ1       = [sq1,pp_bfill]
    SQ2       = [sq2,pp_bfill]
    E_INDEX   = [e_index,pp_bfill]
    NNN       = [nnn,pp_bfill]
    mm        = [mm,pp_bfill]
    code_type = [code_type,pp_bfill]
    sob       = [sob,pp_bfill]
    limhi     = [limhi,pp_bfill]
    limlo     = [limlo,pp_bfill]

endif else begin
    
    pacmo_str = string(sn.hdr.pacmo,'(i1)')
    pick_cvt_sec_vax, [sn.hdr.packet_time(0),$
                       sn.hdr.packet_time(1)], tstr_pack
    
    estat = execute('pdata=sn.pacmo'+pacmo_str) ; Packet data

; How many subpackets do we have?
    n_subp = pdata.data_count
    
    cnum = [cnum,make_array(n_subp,/long,value=checknum)]
    inmodstr = [inmodstr, $
                make_array(n_subp,/string,value='EDI_' + $
                           string(sn.hdr.science_mode,'(z2.2)')+'_'+ $
                           string(sn.hdr.sub_mode,'(z2.2)')+'_'+ $
                           string(sn.data_stream,'(z2.2)')+'_'+ $
                           string(sn.hdr.pacmo,'(z2.2)')+'_'+ $
                           string(sn.shdr.m5.init_table,'(z2.2)')+'_'+ $
                           string(sn.shdr.m5.sob,'(z2.2)')+'_'+ $
                           string(sn.shdr.m5.code_type,'(z2.2)')+'_'+ $
                           string(ep_calc_samtype(sn.shdr.m5.init_table), $
                                  '(z2.2)'))]
    
    btime1    = [btime1,pdata.data(0:n_subp-1).beam_time1] ; Decimal t70, DET1
    btime2    = [btime2,pdata.data(0:n_subp-1).beam_time2] ; Decimal t70, DET2
    
    atime0    = [atime0,pdata.data(0:n_subp-1).atime(0)]
    atime1    = [atime1,pdata.data(0:n_subp-1).atime(1)]
    t1        = [t1,pdata.data(0:n_subp-1).t1] ; DET1
    t1m2      = [t1m2,pdata.data(0:n_subp-1).t1m2]
    
;=====================================================================
;=====================================================================
; New ToF overflow flags:
;     pdata.data(0:n_subp-1).tof_over
;     pdata.data(0:n_subp-1).dtof_p_over
;     pdata.data(0:n_subp-1).dtof_n_over
; If an overflow, or underflow, in the ToF value is
; detected, and the quality of the beam is greater than or equal to 2,
; then we reduce the quality to a "1", meaning angular information is
; OK, but ToF information is substandard (i.e. so these beams can
; still be used for Triangulation, but not for ToF analysis).
; PPQ - February 28th, 2002
    
; DET 1----------------------------
    q1 = pdata.data(0:n_subp-1).sq1
    over1 = where(pdata.data(0:n_subp-1).tof_over eq 1 and $
                  q1 ge 2)
    if (over1(0) ne -1) then q1(over1) = 1 ; Reduce quality if overflow
    
; ToF O-Flags Diag
;ToF-Diag    tof_scale = 1.e3/59.6046
;ToF-Diag    if (over1(0) ne -1) then begin
;ToF-Diag        for i=0,n_elements(over1)-1 do begin
;ToF-Diag            j = over1(i)
;ToF-Diag            tstr = ep_time_handler(pdata.data(j).beam_time1, $
;ToF-Diag                                   't70', 'vax_string')
;ToF-Diag            tof2 = (pdata.data(j).t1-pdata.data(j).t1m2)/tof_scale ; [mics]
;ToF-Diag            dtof = pdata.data(j).t1m2/tof_scale
;ToF-Diag            printf, 55, tstr, ' 1 ', pdata.data(j).sq1, q1(j), dtof, tof2, $
;ToF-Diag              pdata.data(j).tof_over, pdata.data(j).dtof_p_over, $
;ToF-Diag              pdata.data(j).dtof_n_over, $
;ToF-Diag              format='(a27,2x,a3,i1,1x,i1,1x,f9.3,2x,f9.3,2x,3(i1,1x))'
;ToF-Diag        endfor
;ToF-Diag    endif
    
; DET 2----------------------------
    q2 = pdata.data(0:n_subp-1).sq2
    over2 = where((pdata.data(0:n_subp-1).tof_over eq 1 or $
                   pdata.data(0:n_subp-1).dtof_p_over eq 1 or $
                   pdata.data(0:n_subp-1).dtof_n_over eq 1) and $
                  q2 ge 2)
    if (over2(0) ne -1) then q2(over2) = 1 ; Reduce quality if overflow
    
; ToF O-Flags Diag
;ToF-Diag    tof_scale = 1.e3/59.6046
;ToF-Diag    if (over2(0) ne -1) then begin
;ToF-Diag        for i=0,n_elements(over2)-1 do begin
;ToF-Diag            j = over2(i)
;ToF-Diag            tstr = ep_time_handler(pdata.data(j).beam_time2, $
;ToF-Diag                                   't70', 'vax_string')
;ToF-Diag            tof2 = (pdata.data(j).t1-pdata.data(j).t1m2)/tof_scale ; [mics]
;ToF-Diag            dtof = pdata.data(j).t1m2/tof_scale
;ToF-Diag            printf, 55, tstr, ' 2 ', pdata.data(j).sq2, q2(j), dtof, tof2, $
;ToF-Diag              pdata.data(j).tof_over, pdata.data(j).dtof_p_over, $
;ToF-Diag              pdata.data(j).dtof_n_over, $
;ToF-Diag              format='(a27,2x,a3,i1,1x,i1,1x,f9.3,2x,f9.3,2x,3(i1,1x))'
;ToF-Diag        endfor
;ToF-Diag    endif
    
; Orig:    SQ1       = [sq1,pdata.data(0:n_subp-1).sq1] ; DET1
; Orig:    SQ2       = [sq2,pdata.data(0:n_subp-1).sq2] ; DET2
    
    SQ1       = [sq1,q1]        ; DET1
    SQ2       = [sq2,q2]        ; DET2
;=====================================================================
;=====================================================================    

    
    VAX1      = [vax1,pdata.data(0:n_subp-1).vax1]; GUN1
    VAY1      = [vay1,pdata.data(0:n_subp-1).vay1]; GUN1
    VAX2      = [vax2,pdata.data(0:n_subp-1).vax2]; GUN2
    VAY2      = [vay2,pdata.data(0:n_subp-1).vay2]; GUN2
    I1        = [i1,pdata.data(0:n_subp-1).i1] ; DET1
    I2        = [i2,pdata.data(0:n_subp-1).i2] ; DET2
    E_INDEX   = [e_index,pdata.data(0:n_subp-1).e]
    NNN       = [nnn,pdata.data(0:n_subp-1).nnn]
    mm        = [mm,make_array(n_subp,/long,value=sn.shdr.m5.m)]
    code_type = [code_type,$
                 make_array(n_subp,/long,value=sn.shdr.m5.code_type)]
    sob       = [sob,make_array(n_subp,/long,value=sn.shdr.m5.sob)]
    limhi     = [limhi,make_array(n_subp,/long,value=sn.shdr.m5.limhi)]
    limlo     = [limlo,make_array(n_subp,/long,value=sn.shdr.m5.limlo)]

    mxch1     = [mxch1,pdata.data(0:n_subp-1).max_addr1] ; DET1
    mxch2     = [mxch2,pdata.data(0:n_subp-1).max_addr2] ; DET2

endelse

return
end
