pro edi_sprod_create_state_file

common edi_sprod_cb, cb, state_name

; Control parameters
pnames = [cb.param_names1,cb.param_names2] ; String
pdefvals = [cb.param_defs1,cb.param_defs2] ; String
pcurvals = [cb.param_curr1,cb.param_curr2] ; String

pdefvalsf = float(pdefvals)     ; float
pcurvalsf = float(pcurvals)     ; float
id = where( (pdefvalsf - pcurvalsf) ne 0. )

sprod_pp_nvar = 'sprod_pp_nvar'
sprod_pp_varnames = 'sprod_pp_varnames'
sprod_pp_varvalues = 'sprod_pp_varvalues'
if (id(0) eq -1) then begin
    sprod_pp_nvar = sprod_pp_nvar + ' 0'
endif else begin
    sprod_pp_nvar = sprod_pp_nvar + ' '+strtrim(n_elements(id),2)
    for i=0,n_elements(id)-1 do begin
        sprod_pp_varnames = sprod_pp_varnames + ' '+pnames(id(i))
        sprod_pp_varvalues = sprod_pp_varvalues + ' '+pcurvals(id(i))
    endfor
endelse

; tinfo and finfo
year = strmid(cb.date,0,4)
month = strmid(cb.date,4,2)
day = strmid(cb.date,6,2)
if (cb.t1 eq '00:00:00' and cb.t2 eq '24:00:00') then begin
    tstr = 'ALL'
endif else begin
    tstr = $
      strmid(cb.t1,0,2)+'_'+strmid(cb.t1,3,2)+'_'+strmid(cb.t1,6,2)+'-'+ $
      strmid(cb.t2,0,2)+'_'+strmid(cb.t2,3,2)+'_'+strmid(cb.t2,6,2)
endelse
tail = 't00_00_00z.msf'
sprod_tinfo = 'sprod_tinfo'
sprod_finfo = 'sprod_finfo'
sprod_filename_root = 'sprod_filename_root'
scid = where(cb.scnums eq 1)
if (scid(0) ne -1) then begin
    for i=0,n_elements(scid)-1 do begin
        scnum = string(scid(i) + 1,'(i1)')
        sprod_tinfo = sprod_tinfo + ' '+tstr
        sprod_finfo = sprod_finfo + ' cl'+scnum+'_'+year+'-'+month+'-'+ $
          day+tail

        if (cb.filename eq 'auto') then $
          sprod_filename_root = sprod_filename_root+' auto' else $
          sprod_filename_root = sprod_filename_root+' C'+scnum+'_'+strmid(cb.filename,3,strlen(cb.filename)-3)

    endfor
endif else begin
; Make SC3 the default in case one hasn't been chosen
    sprod_tinfo = sprod_tinfo + ' '+tstr
    sprod_finfo = sprod_finfo + ' cl3_'+year+'-'+month+'-'+ $
      day+tail
endelse

; Create 'state' directory and state file.
;spawn, 'mkdir ./'+state_name+'/', stat

openw, unit, './'+state_name+'/'+state_name+'.state', /get_lun
printf, unit, sprod_pp_nvar
printf, unit, sprod_pp_varnames
printf, unit, sprod_pp_varvalues
printf, unit, sprod_tinfo
printf, unit, sprod_finfo
printf, unit, sprod_filename_root
printf, unit, 'sprod_write_cdf '+string(cb.efile_nums(0),'(i1.1)')
printf, unit, 'sprod_write_aux '+string(cb.efile_nums(1),'(i1.1)')
printf, unit, 'sprod_write_arcdf '+string(cb.efile_nums(2),'(i1.1)')

free_lun, unit

return
end
;-----------------------------------------------------------
pro edi_sprod_create_state, str

common edi_sprod_cb, cb, state_name

str = ['Chosen State:']
str = [str,' ']
str = [str,' Filename: '+cb.filename]
str = [str,' Date: '+cb.date]
scid = where(cb.scnums eq 1) + 1
s = ' '
if (scid(0) ne 0) then begin
    for i=0,n_elements(scid)-1 do begin
        s = s+'#'+strtrim(scid(i),2)+' '
    endfor
endif
str = [str,' SC: '+s]
str = [str,' Start Time: '+cb.t1]
str = [str,' Stop Time:  '+cb.t2]
str = [str,' Non-default Control Parameters: ']

j=0
for i=0,n_elements(cb.param_defs1)-1 do begin
    if (cb.param_defs1(i) ne cb.param_curr1(i)) then begin
        j=j+1
        nval = strtrim(cb.param_names1(i),2)
        dval = strtrim(cb.param_defs1(i),2)
        cval = strtrim(cb.param_curr1(i),2)
        str = [str,'   Param/Def/Current: '+nval+'/'+dval+'/'+cval]
    endif
endfor

for i=0,n_elements(cb.param_defs2)-1 do begin
    if (cb.param_defs2(i) ne cb.param_curr2(i)) then begin
        j=j+1
        nval = strtrim(cb.param_names2(i),2)
        dval = strtrim(cb.param_defs2(i),2)
        cval = strtrim(cb.param_curr2(i),2)
        str = [str,'   Param/Def/Current: '+nval+'/'+dval+'/'+cval]
    endif
endfor
if (j eq 0) then str = [str,'     NONE']

if (cb.efile_nums(0)) then str=[str,' Write CDF from IFFALL file']
if (cb.efile_nums(1)) then str=[str,' Write EDI_PISO AUX file']
if (cb.efile_nums(2)) then str=[str,' Write EDI_PISO Archive CDF file']

return
end
;==========================================================
pro edi_sprod_event, ev

common edi_sprod_cb, cb, state_name

if (ev.id eq cb.id_bgrp) then uval=ev.value else $
  widget_control, ev.id, get_uvalue=uval

case uval of
    'date':begin
        widget_control, ev.id, get_value=date
        cb.date = date(0)
        cb.fname_auto = 'C?_EDI_SPROD_'+cb.date+'_'+state_name
        widget_control, cb.id_fname_a, set_value='EDI_SPROD Automated File Name: '+cb.fname_auto+'.iffall (Also .log, .pstat)'
        widget_control, cb.id_fname_a, get_value=val
        if (cb.abut_stat eq 1) then cb.filename = cb.fname_auto
    end
    't1':begin
        widget_control, ev.id, get_value=t1
        cb.t1 = t1(0)
    end
    't2':begin
        widget_control, ev.id, get_value=t2
        cb.t2 = t2(0)
    end
    'scnums':begin
        widget_control, ev.id, get_value=scnums
        cb.scnums = scnums
    end
    'efile_nums':begin
        widget_control, ev.id, get_value=efile_nums
        cb.efile_nums = efile_nums
;        print, cb.efile_nums
    end
    'params1':begin
        pid = ev.index
        cb.nparam1 = pid
        plab = 'Default:'+strtrim(cb.param_defs1(pid),2)+$
          '  Current:'+strtrim(cb.param_curr1(pid),2)
        widget_control, cb.id_plab1, set_value=plab
    end
    'params2':begin
        pid = ev.index
        cb.nparam2 = pid
        plab = 'Default:'+strtrim(cb.param_defs2(pid),2)+$
          '  Current:'+strtrim(cb.param_curr2(pid),2)
        widget_control, cb.id_plab2, set_value=plab
    end
    'pnew1':begin
        widget_control, ev.id, get_value=pnew
        pid = cb.nparam1
        cb.param_curr1(pid) = pnew
        plab = 'Default:'+strtrim(cb.param_defs1(pid),2)+$
          '  Current:'+strtrim(cb.param_curr1(pid),2)
        widget_control, cb.id_plab1, set_value=plab
    end
    'pnew2':begin
        widget_control, ev.id, get_value=pnew
        pid = cb.nparam2
        cb.param_curr2(pid) = pnew
        plab = 'Default:'+strtrim(cb.param_defs2(pid),2)+$
          '  Current:'+strtrim(cb.param_curr2(pid),2)
        widget_control, cb.id_plab2, set_value=plab
    end
    'fname_a2':begin
        widget_control, cb.id_fname, sensitive=0
        cb.filename = 'auto'
        cb.abut_stat = 2
    end
    'fname_a':begin
        widget_control, cb.id_fname, sensitive=0
        cb.filename = cb.fname_auto
        cb.abut_stat = 1
    end
    'fname_u':begin
        widget_control, cb.id_fname, sensitive=1
        widget_control, cb.id_fname, set_value=cb.fname_user
        cb.filename = 'C?_'+cb.fname_user
        cb.abut_stat = 0
    end
    'fname':begin
        widget_control, ev.id, get_value=fn
        cb.fname_user = fn
        cb.filename = 'C?_'+fn
    end
    'submit':begin
        edi_sprod_create_state_file
        widget_control, ev.top, /destroy
        return
    end
    'cancel':begin
        widget_control, ev.top, /destroy
        return
    end
endcase

edi_sprod_create_state, str
widget_control, cb.id_state, set_value=str

return
end

;=========================================

pro edi_sprod, diffmap, code_path, state_name_in

common edi_sprod_cb, cb, state_name

state_name = state_name_in
filename = 'ep_'+diffmap+'_defaults.txt'
ep_extract_envar_info, pp_nvar, pp_varnames, pp_varformat, pp_vartypes, pp_varvalues, filename, path=code_path

; Those control parameters that the user shouldn't/wouldn't change
; (These are the numbers as defined in ${diffmap}_DEF.txt, NOT the indices)
iout = [4, $                    ; pp_order_assign = 1 always
        15, $                   ; pp_outlier_nbeam_min NOT USED ANYMORE
        20, $                   ; pp_cg_acgdu	       NOT USED ANYMORE
        21, $                   ; pp_fg_acgdu	       NOT USED ANYMORE
        24, $                   ; pp_actof_con	       CURRENTLY NOT USED
        26, $                   ; pp_order_use_unrun1  NOT USED ANYMORE
        27, $                   ; pp_order_use_unrun2  NOT USED ANYMORE
        31]                     ; pp_dtof_ambiguity_factor NEVER ASSIGNED
varnames = ['']
varvalues = ['']
for i=0,n_elements(pp_varnames)-1 do begin
    j = where(iout eq i+1)
    if (j(0) eq -1) then begin
        varnames = [varnames,pp_varnames(i)]
        varvalues = [varvalues,pp_varvalues(i)]
    endif
endfor
nval = n_elements(varnames)
varnames = varnames(1:nval-1)
varvalues = varvalues(1:nval-1)

; Split up the control parameters into two groups because the droplist
; can't handle all 48 at one time
n = n_elements(varnames)
varnames1 = varnames(0:n/2)
varnames2 = varnames(n/2+1:n-1)
varvalues1 = varvalues(0:n/2)
varvalues2 = varvalues(n/2+1:n-1)

date_init = '20010704'
cb = {id_date:0L, $
      id_t1:0L, $
      id_t2:0L, $
      id_scnums:0L, $
      id_params1:0L, $
      id_plab1:0L, $
      id_pnew1:0L, $
      id_params2:0L, $
      id_plab2:0L, $
      id_pnew2:0L, $
      id_state:0L, $
      id_submit:0L, $
      id_fname:0L, $
      id_fname_but:0L, $
      id_fname_a:0L, $
      id_fname_a2:0L, $
      id_bgrp:0L, $
      id_efiles:0L, $
      abut_stat:0L, $
      filename:'C?_EDI_SPROD_'+date_init+'_'+state_name, $
      fname_user:'YOUR_OWN_NAME', $
      fname_auto:'C?_EDI_SPROD_'+date_init+'_'+state_name, $
      fname_auto_ep:'YYYYMMDD_?_HHMMSS_v?_??_DM??_0_iffall.d', $
      date:date_init, $
      t1:'00:00:00', $
      t2:'24:00:00', $
      scnums:[1,0,0,0], $
      efile_nums:[0,0,0], $
      nparam1:0, $
      param_names1:varnames1, $
      param_defs1:varvalues1, $
      param_curr1:varvalues1, $
      nparam2:0, $
      param_names2:varnames2, $
      param_defs2:varvalues2, $
      param_curr2:varvalues2}

base = widget_base(/col, /frame, /base_align_center,title='EDI_PISO "SPECIAL" PRODUCTION (EDI_SPROD)')

basel = widget_base(base,/row, /align_center)
baser = widget_base(base,/col, /align_center)

basel1 = widget_base(basel, /frame, /col, /align_center)

basel2 = widget_base(basel, /col, /align_center, /base_align_center)

basel21 = widget_base(basel2, /col, /frame, /align_center, /base_align_center)

basel22 = widget_base(basel2, /col, /frame, /align_center, /base_align_center)

;============================================================
; LEFT
;============================================================
cb.id_date = cw_field(basel1,/all_events,title='Date:  ',uvalue='date', $
                      value=cb.date,xsize=8)

cb.id_t1 = cw_field(basel1,/all_events,title='Start: ',uvalue='t1', $
                    value=cb.t1,xsize=8)

cb.id_t2 = cw_field(basel1,/all_events,title='Stop:  ',uvalue='t2', $
                    value=cb.t2,xsize=8)

cb.id_scnums = cw_bgroup(basel1,['1','2','3','4'], $
                         button_uvalue=['1','2','3','4'], $
                         uvalue='scnums', label_top='Spacecraft #(s)', $
                         column=4, $
                         /nonexclusive)
widget_control, cb.id_scnums, set_value=cb.scnums

;============================================================
; RIGHT
;============================================================

cb.id_params1 = widget_droplist(basel21,title='Cntl Prmtrs 1:', $
                                uvalue='params1',$
                                value=cb.param_names1)

pid = cb.nparam1
plab = 'Default:'+strtrim(cb.param_defs1(pid),2)+$
  '  Current:'+strtrim(cb.param_curr1(pid),2)
cb.id_plab1 = widget_label(basel21,value=plab,/align_center,/dynamic_resize)

pnew = cb.param_curr1(pid)
cb.id_pnew1 = cw_field(basel21,/return_events, $
                       title='New (must hit return):  ',uvalue='pnew1', $
                       value=pnew,xsize=4)
;------------
cb.id_params2 = widget_droplist(basel22,title='Cntl Prmtrs 2:', $
                                uvalue='params2',$
                                value=cb.param_names2)

pid = cb.nparam2
plab = 'Default:'+strtrim(cb.param_defs2(pid),2)+$
  '  Current:'+strtrim(cb.param_curr2(pid),2)
cb.id_plab2 = widget_label(basel22,value=plab,/align_center,/dynamic_resize)

pnew = cb.param_curr2(pid)
cb.id_pnew2 = cw_field(basel22,/return_events, $
                       title='New (must hit return):  ',uvalue='pnew2', $
                       value=pnew,xsize=4)

;============================================================
; BOTTOM
;============================================================

; Filename
baser1 = widget_base(baser,/col,/align_left,/exclusive)

cb.id_fname_a = widget_button(baser1, value='EDI_SPROD Automated File Name: '+cb.fname_auto+'.iffall (Also .log, .pstat)', uvalue='fname_a')
widget_control, cb.id_fname_a, /set_button
cb.abut_stat = 1

cb.id_fname_a2 = widget_button(baser1, value='EDI_PISO Automated File Name: '+cb.fname_auto_ep+' (Also .log, .pstat)', uvalue='fname_a2')

cb.id_fname_but = widget_button(baser1, value='User Defined File Name (no extension!):', uvalue='fname_u')

cb.id_fname = cw_field(baser,/all_events, $
                       title='   Enter Name:    C?_',uvalue='fname', $
                       value=cb.fname_user,xsize=60)
widget_control, cb.id_fname, sensitive=0

; Extra Files
baser2 = widget_base(baser,/row,/align_left,/frame)

cb.id_efiles = cw_bgroup(baser2,['Write CDF from IFFALL file','Write EDI_PISO AUX file','Write EDI_PISO Archive CDF file'], $
                         button_uvalue=['1','2','3'], $
                         uvalue='efile_nums', label_top='Extra File Production', $
                         row=3, $
                         /nonexclusive)
widget_control, cb.id_efiles, set_value=cb.efile_nums

; State Window
edi_sprod_create_state, str
cb.id_state = widget_text(baser,/frame,uvalue='state', $
                          value=str,xsize=60,ysize=20,/scroll,/wrap)

;cb.id_submit = widget_button(base, value='Submit',uvalue='submit')

cb.id_bgrp = cw_bgroup(base, ['   Submit   ','   Cancel   '], button_uvalue=['submit','cancel'], /row)

widget_control, base, /realize
xmanager, 'edi_sprod', base

return
end
